/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.GroupCallParticipant;
import telegram4j.tl.GroupCallParticipantVideo;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableGroupCallParticipant
implements GroupCallParticipant {
    private final int identifier;
    private final int flags;
    private final boolean muted;
    private final boolean left;
    private final boolean canSelfUnmute;
    private final boolean justJoined;
    private final boolean versioned;
    private final boolean min;
    private final boolean mutedByYou;
    private final boolean volumeByAdmin;
    private final boolean self;
    private final boolean videoJoined;
    private final Peer peer;
    private final int date;
    @Nullable
    private final Integer activeDate;
    private final int source;
    @Nullable
    private final Integer volume;
    @Nullable
    private final String about;
    @Nullable
    private final Long raiseHandRating;
    @Nullable
    private final GroupCallParticipantVideo video;
    @Nullable
    private final GroupCallParticipantVideo presentation;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGroupCallParticipant(Peer peer, int date, int source) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.date = date;
        this.source = source;
        this.activeDate = null;
        this.volume = null;
        this.about = null;
        this.raiseHandRating = null;
        this.video = null;
        this.presentation = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.muted = this.initShim.muted();
        this.left = this.initShim.left();
        this.canSelfUnmute = this.initShim.canSelfUnmute();
        this.justJoined = this.initShim.justJoined();
        this.versioned = this.initShim.versioned();
        this.min = this.initShim.min();
        this.mutedByYou = this.initShim.mutedByYou();
        this.volumeByAdmin = this.initShim.volumeByAdmin();
        this.self = this.initShim.self();
        this.videoJoined = this.initShim.videoJoined();
        this.initShim = null;
    }

    private ImmutableGroupCallParticipant(Builder builder) {
        this.peer = builder.peer;
        this.date = builder.date;
        this.activeDate = builder.activeDate;
        this.source = builder.source;
        this.volume = builder.volume;
        this.about = builder.about;
        this.raiseHandRating = builder.raiseHandRating;
        this.video = builder.video;
        this.presentation = builder.presentation;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.mutedIsSet()) {
            this.initShim.muted(builder.muted);
        }
        if (builder.leftIsSet()) {
            this.initShim.left(builder.left);
        }
        if (builder.canSelfUnmuteIsSet()) {
            this.initShim.canSelfUnmute(builder.canSelfUnmute);
        }
        if (builder.justJoinedIsSet()) {
            this.initShim.justJoined(builder.justJoined);
        }
        if (builder.versionedIsSet()) {
            this.initShim.versioned(builder.versioned);
        }
        if (builder.minIsSet()) {
            this.initShim.min(builder.min);
        }
        if (builder.mutedByYouIsSet()) {
            this.initShim.mutedByYou(builder.mutedByYou);
        }
        if (builder.volumeByAdminIsSet()) {
            this.initShim.volumeByAdmin(builder.volumeByAdmin);
        }
        if (builder.selfIsSet()) {
            this.initShim.self(builder.self);
        }
        if (builder.videoJoinedIsSet()) {
            this.initShim.videoJoined(builder.videoJoined);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.muted = this.initShim.muted();
        this.left = this.initShim.left();
        this.canSelfUnmute = this.initShim.canSelfUnmute();
        this.justJoined = this.initShim.justJoined();
        this.versioned = this.initShim.versioned();
        this.min = this.initShim.min();
        this.mutedByYou = this.initShim.mutedByYou();
        this.volumeByAdmin = this.initShim.volumeByAdmin();
        this.self = this.initShim.self();
        this.videoJoined = this.initShim.videoJoined();
        this.initShim = null;
    }

    private ImmutableGroupCallParticipant(int identifier, int flags, boolean muted, boolean left, boolean canSelfUnmute, boolean justJoined, boolean versioned, boolean min, boolean mutedByYou, boolean volumeByAdmin, boolean self, boolean videoJoined, Peer peer, int date, @Nullable Integer activeDate, int source, @Nullable Integer volume, @Nullable String about, @Nullable Long raiseHandRating, @Nullable GroupCallParticipantVideo video, @Nullable GroupCallParticipantVideo presentation) {
        this.identifier = identifier;
        this.flags = flags;
        this.muted = muted;
        this.left = left;
        this.canSelfUnmute = canSelfUnmute;
        this.justJoined = justJoined;
        this.versioned = versioned;
        this.min = min;
        this.mutedByYou = mutedByYou;
        this.volumeByAdmin = volumeByAdmin;
        this.self = self;
        this.videoJoined = videoJoined;
        this.peer = peer;
        this.date = date;
        this.activeDate = activeDate;
        this.source = source;
        this.volume = volume;
        this.about = about;
        this.raiseHandRating = raiseHandRating;
        this.video = video;
        this.presentation = presentation;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GroupCallParticipant.super.identifier();
    }

    private int flagsInitialize() {
        return GroupCallParticipant.super.flags();
    }

    private boolean mutedInitialize() {
        return GroupCallParticipant.super.muted();
    }

    private boolean leftInitialize() {
        return GroupCallParticipant.super.left();
    }

    private boolean canSelfUnmuteInitialize() {
        return GroupCallParticipant.super.canSelfUnmute();
    }

    private boolean justJoinedInitialize() {
        return GroupCallParticipant.super.justJoined();
    }

    private boolean versionedInitialize() {
        return GroupCallParticipant.super.versioned();
    }

    private boolean minInitialize() {
        return GroupCallParticipant.super.min();
    }

    private boolean mutedByYouInitialize() {
        return GroupCallParticipant.super.mutedByYou();
    }

    private boolean volumeByAdminInitialize() {
        return GroupCallParticipant.super.volumeByAdmin();
    }

    private boolean selfInitialize() {
        return GroupCallParticipant.super.self();
    }

    private boolean videoJoinedInitialize() {
        return GroupCallParticipant.super.videoJoined();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean muted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.muted() : this.muted;
    }

    @Override
    public boolean left() {
        InitShim shim = this.initShim;
        return shim != null ? shim.left() : this.left;
    }

    @Override
    public boolean canSelfUnmute() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSelfUnmute() : this.canSelfUnmute;
    }

    @Override
    public boolean justJoined() {
        InitShim shim = this.initShim;
        return shim != null ? shim.justJoined() : this.justJoined;
    }

    @Override
    public boolean versioned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.versioned() : this.versioned;
    }

    @Override
    public boolean min() {
        InitShim shim = this.initShim;
        return shim != null ? shim.min() : this.min;
    }

    @Override
    public boolean mutedByYou() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mutedByYou() : this.mutedByYou;
    }

    @Override
    public boolean volumeByAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.volumeByAdmin() : this.volumeByAdmin;
    }

    @Override
    public boolean self() {
        InitShim shim = this.initShim;
        return shim != null ? shim.self() : this.self;
    }

    @Override
    public boolean videoJoined() {
        InitShim shim = this.initShim;
        return shim != null ? shim.videoJoined() : this.videoJoined;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public Integer activeDate() {
        return this.activeDate;
    }

    @Override
    public int source() {
        return this.source;
    }

    @Override
    @Nullable
    public Integer volume() {
        return this.volume;
    }

    @Override
    @Nullable
    public String about() {
        return this.about;
    }

    @Override
    @Nullable
    public Long raiseHandRating() {
        return this.raiseHandRating;
    }

    @Override
    @Nullable
    public GroupCallParticipantVideo video() {
        return this.video;
    }

    @Override
    @Nullable
    public GroupCallParticipantVideo presentation() {
        return this.presentation;
    }

    public final ImmutableGroupCallParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(value, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, value, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withMuted(boolean value) {
        if (this.muted == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, value, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withLeft(boolean value) {
        if (this.left == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, value, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withCanSelfUnmute(boolean value) {
        if (this.canSelfUnmute == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, value, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withJustJoined(boolean value) {
        if (this.justJoined == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, value, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withVersioned(boolean value) {
        if (this.versioned == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, value, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withMin(boolean value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, value, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withMutedByYou(boolean value) {
        if (this.mutedByYou == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, value, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withVolumeByAdmin(boolean value) {
        if (this.volumeByAdmin == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, value, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withSelf(boolean value) {
        if (this.self == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, value, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withVideoJoined(boolean value) {
        if (this.videoJoined == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, value, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, newValue, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, value, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withActiveDate(@Nullable Integer value) {
        if (Objects.equals(this.activeDate, value)) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, value, this.source, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withSource(int value) {
        if (this.source == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, value, this.volume, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withVolume(@Nullable Integer value) {
        if (Objects.equals(this.volume, value)) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, value, this.about, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withAbout(@Nullable String value) {
        if (Objects.equals(this.about, value)) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, value, this.raiseHandRating, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withRaiseHandRating(@Nullable Long value) {
        if (Objects.equals(this.raiseHandRating, value)) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, value, this.video, this.presentation);
    }

    public final ImmutableGroupCallParticipant withVideo(@Nullable GroupCallParticipantVideo value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, value, this.presentation);
    }

    public final ImmutableGroupCallParticipant withPresentation(@Nullable GroupCallParticipantVideo value) {
        if (this.presentation == value) {
            return this;
        }
        return new ImmutableGroupCallParticipant(this.identifier, this.flags, this.muted, this.left, this.canSelfUnmute, this.justJoined, this.versioned, this.min, this.mutedByYou, this.volumeByAdmin, this.self, this.videoJoined, this.peer, this.date, this.activeDate, this.source, this.volume, this.about, this.raiseHandRating, this.video, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallParticipant && this.equalTo(0, (ImmutableGroupCallParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallParticipant another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.muted == another.muted && this.left == another.left && this.canSelfUnmute == another.canSelfUnmute && this.justJoined == another.justJoined && this.versioned == another.versioned && this.min == another.min && this.mutedByYou == another.mutedByYou && this.volumeByAdmin == another.volumeByAdmin && this.self == another.self && this.videoJoined == another.videoJoined && this.peer.equals(another.peer) && this.date == another.date && Objects.equals(this.activeDate, another.activeDate) && this.source == another.source && Objects.equals(this.volume, another.volume) && Objects.equals(this.about, another.about) && Objects.equals(this.raiseHandRating, another.raiseHandRating) && Objects.equals(this.video, another.video) && Objects.equals(this.presentation, another.presentation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.muted);
        h += (h << 5) + Boolean.hashCode(this.left);
        h += (h << 5) + Boolean.hashCode(this.canSelfUnmute);
        h += (h << 5) + Boolean.hashCode(this.justJoined);
        h += (h << 5) + Boolean.hashCode(this.versioned);
        h += (h << 5) + Boolean.hashCode(this.min);
        h += (h << 5) + Boolean.hashCode(this.mutedByYou);
        h += (h << 5) + Boolean.hashCode(this.volumeByAdmin);
        h += (h << 5) + Boolean.hashCode(this.self);
        h += (h << 5) + Boolean.hashCode(this.videoJoined);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.activeDate);
        h += (h << 5) + this.source;
        h += (h << 5) + Objects.hashCode(this.volume);
        h += (h << 5) + Objects.hashCode(this.about);
        h += (h << 5) + Objects.hashCode(this.raiseHandRating);
        h += (h << 5) + Objects.hashCode(this.video);
        h += (h << 5) + Objects.hashCode(this.presentation);
        return h;
    }

    public String toString() {
        return "GroupCallParticipant{identifier=" + this.identifier + ", flags=" + this.flags + ", muted=" + this.muted + ", left=" + this.left + ", canSelfUnmute=" + this.canSelfUnmute + ", justJoined=" + this.justJoined + ", versioned=" + this.versioned + ", min=" + this.min + ", mutedByYou=" + this.mutedByYou + ", volumeByAdmin=" + this.volumeByAdmin + ", self=" + this.self + ", videoJoined=" + this.videoJoined + ", peer=" + this.peer + ", date=" + this.date + ", activeDate=" + this.activeDate + ", source=" + this.source + ", volume=" + this.volume + ", about=" + this.about + ", raiseHandRating=" + this.raiseHandRating + ", video=" + this.video + ", presentation=" + this.presentation + "}";
    }

    public static ImmutableGroupCallParticipant of(Peer peer, int date, int source) {
        return new ImmutableGroupCallParticipant(peer, date, source);
    }

    public static ImmutableGroupCallParticipant copyOf(GroupCallParticipant instance) {
        if (instance instanceof ImmutableGroupCallParticipant) {
            return (ImmutableGroupCallParticipant)instance;
        }
        return ImmutableGroupCallParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MUTED = 4L;
        private static final long OPT_BIT_LEFT = 8L;
        private static final long OPT_BIT_CAN_SELF_UNMUTE = 16L;
        private static final long OPT_BIT_JUST_JOINED = 32L;
        private static final long OPT_BIT_VERSIONED = 64L;
        private static final long OPT_BIT_MIN = 128L;
        private static final long OPT_BIT_MUTED_BY_YOU = 256L;
        private static final long OPT_BIT_VOLUME_BY_ADMIN = 512L;
        private static final long OPT_BIT_SELF = 1024L;
        private static final long OPT_BIT_VIDEO_JOINED = 2048L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean muted;
        private boolean left;
        private boolean canSelfUnmute;
        private boolean justJoined;
        private boolean versioned;
        private boolean min;
        private boolean mutedByYou;
        private boolean volumeByAdmin;
        private boolean self;
        private boolean videoJoined;
        private Peer peer;
        private int date;
        private Integer activeDate;
        private int source;
        private Integer volume;
        private String about;
        private Long raiseHandRating;
        private GroupCallParticipantVideo video;
        private GroupCallParticipantVideo presentation;

        private Builder() {
        }

        public final Builder from(GroupCallParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCallParticipant instance;
            long bits = 0L;
            if (object instanceof GroupCallParticipant) {
                GroupCallParticipantVideo presentationValue;
                Integer volumeValue;
                instance = (GroupCallParticipant)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.videoJoined(instance.videoJoined());
                this.flags(instance.flags());
                this.justJoined(instance.justJoined());
                String aboutValue = instance.about();
                if (aboutValue != null) {
                    this.about(aboutValue);
                }
                this.source(instance.source());
                GroupCallParticipantVideo videoValue = instance.video();
                if (videoValue != null) {
                    this.video(videoValue);
                }
                if ((volumeValue = instance.volume()) != null) {
                    this.volume(volumeValue);
                }
                if ((presentationValue = instance.presentation()) != null) {
                    this.presentation(presentationValue);
                }
                this.min(instance.min());
                this.volumeByAdmin(instance.volumeByAdmin());
                this.left(instance.left());
                this.mutedByYou(instance.mutedByYou());
                this.versioned(instance.versioned());
                this.peer(instance.peer());
                Integer activeDateValue = instance.activeDate();
                if (activeDateValue != null) {
                    this.activeDate(activeDateValue);
                }
                this.canSelfUnmute(instance.canSelfUnmute());
                this.self(instance.self());
                this.muted(instance.muted());
                Long raiseHandRatingValue = instance.raiseHandRating();
                if (raiseHandRatingValue != null) {
                    this.raiseHandRating(raiseHandRatingValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder muted(boolean muted) {
            this.muted = muted;
            this.optBits |= 4L;
            return this;
        }

        public final Builder left(boolean left) {
            this.left = left;
            this.optBits |= 8L;
            return this;
        }

        public final Builder canSelfUnmute(boolean canSelfUnmute) {
            this.canSelfUnmute = canSelfUnmute;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder justJoined(boolean justJoined) {
            this.justJoined = justJoined;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder versioned(boolean versioned) {
            this.versioned = versioned;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder min(boolean min) {
            this.min = min;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder mutedByYou(boolean mutedByYou) {
            this.mutedByYou = mutedByYou;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder volumeByAdmin(boolean volumeByAdmin) {
            this.volumeByAdmin = volumeByAdmin;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder self(boolean self) {
            this.self = self;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder videoJoined(boolean videoJoined) {
            this.videoJoined = videoJoined;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder activeDate(@Nullable Integer activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Builder source(int source) {
            this.source = source;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder volume(@Nullable Integer volume) {
            this.volume = volume;
            return this;
        }

        public final Builder about(@Nullable String about) {
            this.about = about;
            return this;
        }

        public final Builder raiseHandRating(@Nullable Long raiseHandRating) {
            this.raiseHandRating = raiseHandRating;
            return this;
        }

        public final Builder video(@Nullable GroupCallParticipantVideo video) {
            this.video = video;
            return this;
        }

        public final Builder presentation(@Nullable GroupCallParticipantVideo presentation) {
            this.presentation = presentation;
            return this;
        }

        public ImmutableGroupCallParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCallParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean mutedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean leftIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean canSelfUnmuteIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean justJoinedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean versionedIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean minIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean mutedByYouIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean volumeByAdminIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean selfIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean videoJoinedIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build GroupCallParticipant, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte mutedBuildStage = 0;
        private boolean muted;
        private byte leftBuildStage = 0;
        private boolean left;
        private byte canSelfUnmuteBuildStage = 0;
        private boolean canSelfUnmute;
        private byte justJoinedBuildStage = 0;
        private boolean justJoined;
        private byte versionedBuildStage = 0;
        private boolean versioned;
        private byte minBuildStage = 0;
        private boolean min;
        private byte mutedByYouBuildStage = 0;
        private boolean mutedByYou;
        private byte volumeByAdminBuildStage = 0;
        private boolean volumeByAdmin;
        private byte selfBuildStage = 0;
        private boolean self;
        private byte videoJoinedBuildStage = 0;
        private boolean videoJoined;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGroupCallParticipant.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGroupCallParticipant.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean muted() {
            if (this.mutedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutedBuildStage == 0) {
                this.mutedBuildStage = (byte)-1;
                this.muted = ImmutableGroupCallParticipant.this.mutedInitialize();
                this.mutedBuildStage = 1;
            }
            return this.muted;
        }

        void muted(boolean muted) {
            this.muted = muted;
            this.mutedBuildStage = 1;
        }

        boolean left() {
            if (this.leftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.leftBuildStage == 0) {
                this.leftBuildStage = (byte)-1;
                this.left = ImmutableGroupCallParticipant.this.leftInitialize();
                this.leftBuildStage = 1;
            }
            return this.left;
        }

        void left(boolean left) {
            this.left = left;
            this.leftBuildStage = 1;
        }

        boolean canSelfUnmute() {
            if (this.canSelfUnmuteBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSelfUnmuteBuildStage == 0) {
                this.canSelfUnmuteBuildStage = (byte)-1;
                this.canSelfUnmute = ImmutableGroupCallParticipant.this.canSelfUnmuteInitialize();
                this.canSelfUnmuteBuildStage = 1;
            }
            return this.canSelfUnmute;
        }

        void canSelfUnmute(boolean canSelfUnmute) {
            this.canSelfUnmute = canSelfUnmute;
            this.canSelfUnmuteBuildStage = 1;
        }

        boolean justJoined() {
            if (this.justJoinedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.justJoinedBuildStage == 0) {
                this.justJoinedBuildStage = (byte)-1;
                this.justJoined = ImmutableGroupCallParticipant.this.justJoinedInitialize();
                this.justJoinedBuildStage = 1;
            }
            return this.justJoined;
        }

        void justJoined(boolean justJoined) {
            this.justJoined = justJoined;
            this.justJoinedBuildStage = 1;
        }

        boolean versioned() {
            if (this.versionedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionedBuildStage == 0) {
                this.versionedBuildStage = (byte)-1;
                this.versioned = ImmutableGroupCallParticipant.this.versionedInitialize();
                this.versionedBuildStage = 1;
            }
            return this.versioned;
        }

        void versioned(boolean versioned) {
            this.versioned = versioned;
            this.versionedBuildStage = 1;
        }

        boolean min() {
            if (this.minBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBuildStage == 0) {
                this.minBuildStage = (byte)-1;
                this.min = ImmutableGroupCallParticipant.this.minInitialize();
                this.minBuildStage = 1;
            }
            return this.min;
        }

        void min(boolean min) {
            this.min = min;
            this.minBuildStage = 1;
        }

        boolean mutedByYou() {
            if (this.mutedByYouBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutedByYouBuildStage == 0) {
                this.mutedByYouBuildStage = (byte)-1;
                this.mutedByYou = ImmutableGroupCallParticipant.this.mutedByYouInitialize();
                this.mutedByYouBuildStage = 1;
            }
            return this.mutedByYou;
        }

        void mutedByYou(boolean mutedByYou) {
            this.mutedByYou = mutedByYou;
            this.mutedByYouBuildStage = 1;
        }

        boolean volumeByAdmin() {
            if (this.volumeByAdminBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.volumeByAdminBuildStage == 0) {
                this.volumeByAdminBuildStage = (byte)-1;
                this.volumeByAdmin = ImmutableGroupCallParticipant.this.volumeByAdminInitialize();
                this.volumeByAdminBuildStage = 1;
            }
            return this.volumeByAdmin;
        }

        void volumeByAdmin(boolean volumeByAdmin) {
            this.volumeByAdmin = volumeByAdmin;
            this.volumeByAdminBuildStage = 1;
        }

        boolean self() {
            if (this.selfBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selfBuildStage == 0) {
                this.selfBuildStage = (byte)-1;
                this.self = ImmutableGroupCallParticipant.this.selfInitialize();
                this.selfBuildStage = 1;
            }
            return this.self;
        }

        void self(boolean self) {
            this.self = self;
            this.selfBuildStage = 1;
        }

        boolean videoJoined() {
            if (this.videoJoinedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoJoinedBuildStage == 0) {
                this.videoJoinedBuildStage = (byte)-1;
                this.videoJoined = ImmutableGroupCallParticipant.this.videoJoinedInitialize();
                this.videoJoinedBuildStage = 1;
            }
            return this.videoJoined;
        }

        void videoJoined(boolean videoJoined) {
            this.videoJoined = videoJoined;
            this.videoJoinedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.mutedBuildStage == -1) {
                attributes.add("muted");
            }
            if (this.leftBuildStage == -1) {
                attributes.add("left");
            }
            if (this.canSelfUnmuteBuildStage == -1) {
                attributes.add("canSelfUnmute");
            }
            if (this.justJoinedBuildStage == -1) {
                attributes.add("justJoined");
            }
            if (this.versionedBuildStage == -1) {
                attributes.add("versioned");
            }
            if (this.minBuildStage == -1) {
                attributes.add("min");
            }
            if (this.mutedByYouBuildStage == -1) {
                attributes.add("mutedByYou");
            }
            if (this.volumeByAdminBuildStage == -1) {
                attributes.add("volumeByAdmin");
            }
            if (this.selfBuildStage == -1) {
                attributes.add("self");
            }
            if (this.videoJoinedBuildStage == -1) {
                attributes.add("videoJoined");
            }
            return "Cannot build GroupCallParticipant, attribute initializers form cycle " + attributes;
        }
    }
}

