/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.GroupCallParticipantVideo;
import telegram4j.tl.GroupCallParticipantVideoSourceGroup;
import telegram4j.tl.api.TlObject;

public final class ImmutableGroupCallParticipantVideo
implements GroupCallParticipantVideo {
    private final int identifier;
    private final int flags;
    private final boolean paused;
    private final String endpoint;
    private final List<GroupCallParticipantVideoSourceGroup> sourceGroups;
    @Nullable
    private final Integer audioSource;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGroupCallParticipantVideo(String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
        this.sourceGroups = Collections.emptyList();
        this.audioSource = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.paused = this.initShim.paused();
        this.initShim = null;
    }

    private ImmutableGroupCallParticipantVideo(Builder builder) {
        this.endpoint = builder.endpoint;
        this.sourceGroups = ImmutableGroupCallParticipantVideo.createUnmodifiableList(true, builder.sourceGroups);
        this.audioSource = builder.audioSource;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pausedIsSet()) {
            this.initShim.paused(builder.paused);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.paused = this.initShim.paused();
        this.initShim = null;
    }

    private ImmutableGroupCallParticipantVideo(int identifier, int flags, boolean paused, String endpoint, List<GroupCallParticipantVideoSourceGroup> sourceGroups, @Nullable Integer audioSource) {
        this.identifier = identifier;
        this.flags = flags;
        this.paused = paused;
        this.endpoint = endpoint;
        this.sourceGroups = sourceGroups;
        this.audioSource = audioSource;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GroupCallParticipantVideo.super.identifier();
    }

    private int flagsInitialize() {
        return GroupCallParticipantVideo.super.flags();
    }

    private boolean pausedInitialize() {
        return GroupCallParticipantVideo.super.paused();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean paused() {
        InitShim shim = this.initShim;
        return shim != null ? shim.paused() : this.paused;
    }

    @Override
    public String endpoint() {
        return this.endpoint;
    }

    @Override
    public List<GroupCallParticipantVideoSourceGroup> sourceGroups() {
        return this.sourceGroups;
    }

    @Override
    @Nullable
    public Integer audioSource() {
        return this.audioSource;
    }

    public final ImmutableGroupCallParticipantVideo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideo(value, this.flags, this.paused, this.endpoint, this.sourceGroups, this.audioSource);
    }

    public final ImmutableGroupCallParticipantVideo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideo(this.identifier, value, this.paused, this.endpoint, this.sourceGroups, this.audioSource);
    }

    public final ImmutableGroupCallParticipantVideo withPaused(boolean value) {
        if (this.paused == value) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideo(this.identifier, this.flags, value, this.endpoint, this.sourceGroups, this.audioSource);
    }

    public final ImmutableGroupCallParticipantVideo withEndpoint(String value) {
        String newValue = Objects.requireNonNull(value, "endpoint");
        if (this.endpoint.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideo(this.identifier, this.flags, this.paused, newValue, this.sourceGroups, this.audioSource);
    }

    public final ImmutableGroupCallParticipantVideo withSourceGroups(GroupCallParticipantVideoSourceGroup ... elements) {
        List<GroupCallParticipantVideoSourceGroup> newValue = ImmutableGroupCallParticipantVideo.createUnmodifiableList(false, ImmutableGroupCallParticipantVideo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupCallParticipantVideo(this.identifier, this.flags, this.paused, this.endpoint, newValue, this.audioSource);
    }

    public final ImmutableGroupCallParticipantVideo withSourceGroups(Iterable<? extends GroupCallParticipantVideoSourceGroup> elements) {
        if (this.sourceGroups == elements) {
            return this;
        }
        List<GroupCallParticipantVideoSourceGroup> newValue = ImmutableGroupCallParticipantVideo.createUnmodifiableList(false, ImmutableGroupCallParticipantVideo.createSafeList(elements, true, false));
        return new ImmutableGroupCallParticipantVideo(this.identifier, this.flags, this.paused, this.endpoint, newValue, this.audioSource);
    }

    public final ImmutableGroupCallParticipantVideo withAudioSource(@Nullable Integer value) {
        if (Objects.equals(this.audioSource, value)) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideo(this.identifier, this.flags, this.paused, this.endpoint, this.sourceGroups, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallParticipantVideo && this.equalTo(0, (ImmutableGroupCallParticipantVideo)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallParticipantVideo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.paused == another.paused && this.endpoint.equals(another.endpoint) && this.sourceGroups.equals(another.sourceGroups) && Objects.equals(this.audioSource, another.audioSource);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.paused);
        h += (h << 5) + this.endpoint.hashCode();
        h += (h << 5) + this.sourceGroups.hashCode();
        h += (h << 5) + Objects.hashCode(this.audioSource);
        return h;
    }

    public String toString() {
        return "GroupCallParticipantVideo{identifier=" + this.identifier + ", flags=" + this.flags + ", paused=" + this.paused + ", endpoint=" + this.endpoint + ", sourceGroups=" + this.sourceGroups + ", audioSource=" + this.audioSource + "}";
    }

    public static ImmutableGroupCallParticipantVideo of(String endpoint) {
        return new ImmutableGroupCallParticipantVideo(endpoint);
    }

    public static ImmutableGroupCallParticipantVideo copyOf(GroupCallParticipantVideo instance) {
        if (instance instanceof ImmutableGroupCallParticipantVideo) {
            return (ImmutableGroupCallParticipantVideo)instance;
        }
        return ImmutableGroupCallParticipantVideo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ENDPOINT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PAUSED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean paused;
        private String endpoint;
        private List<GroupCallParticipantVideoSourceGroup> sourceGroups = new ArrayList<GroupCallParticipantVideoSourceGroup>();
        private Integer audioSource;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GroupCallParticipantVideo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GroupCallParticipantVideo) {
                Integer audioSourceValue;
                instance = (GroupCallParticipantVideo)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((audioSourceValue = instance.audioSource()) != null) {
                    this.audioSource(audioSourceValue);
                }
                this.paused(instance.paused());
                this.endpoint(instance.endpoint());
                this.addAllSourceGroups(instance.sourceGroups());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder paused(boolean paused) {
            this.paused = paused;
            this.optBits |= 4L;
            return this;
        }

        public final Builder endpoint(String endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSourceGroup(GroupCallParticipantVideoSourceGroup element) {
            this.sourceGroups.add(Objects.requireNonNull(element, "sourceGroups element"));
            return this;
        }

        public final Builder addSourceGroups(GroupCallParticipantVideoSourceGroup ... elements) {
            for (GroupCallParticipantVideoSourceGroup element : elements) {
                this.sourceGroups.add(Objects.requireNonNull(element, "sourceGroups element"));
            }
            return this;
        }

        public final Builder sourceGroups(Iterable<? extends GroupCallParticipantVideoSourceGroup> elements) {
            this.sourceGroups.clear();
            return this.addAllSourceGroups(elements);
        }

        public final Builder addAllSourceGroups(Iterable<? extends GroupCallParticipantVideoSourceGroup> elements) {
            for (GroupCallParticipantVideoSourceGroup groupCallParticipantVideoSourceGroup : elements) {
                this.sourceGroups.add(Objects.requireNonNull(groupCallParticipantVideoSourceGroup, "sourceGroups element"));
            }
            return this;
        }

        public final Builder audioSource(@Nullable Integer audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        public ImmutableGroupCallParticipantVideo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCallParticipantVideo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pausedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("endpoint");
            }
            return "Cannot build GroupCallParticipantVideo, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pausedBuildStage = 0;
        private boolean paused;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGroupCallParticipantVideo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGroupCallParticipantVideo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean paused() {
            if (this.pausedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pausedBuildStage == 0) {
                this.pausedBuildStage = (byte)-1;
                this.paused = ImmutableGroupCallParticipantVideo.this.pausedInitialize();
                this.pausedBuildStage = 1;
            }
            return this.paused;
        }

        void paused(boolean paused) {
            this.paused = paused;
            this.pausedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pausedBuildStage == -1) {
                attributes.add("paused");
            }
            return "Cannot build GroupCallParticipantVideo, attribute initializers form cycle " + attributes;
        }
    }
}

