/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.GroupCallParticipantVideoSourceGroup;
import telegram4j.tl.api.TlObject;

public final class ImmutableGroupCallParticipantVideoSourceGroup
implements GroupCallParticipantVideoSourceGroup {
    private final int identifier;
    private final String semantics;
    private final List<Integer> sources;

    private ImmutableGroupCallParticipantVideoSourceGroup(String semantics) {
        this.semantics = Objects.requireNonNull(semantics, "semantics");
        this.sources = Collections.emptyList();
        this.identifier = GroupCallParticipantVideoSourceGroup.super.identifier();
    }

    private ImmutableGroupCallParticipantVideoSourceGroup(Builder builder) {
        this.semantics = builder.semantics;
        this.sources = ImmutableGroupCallParticipantVideoSourceGroup.createUnmodifiableList(true, builder.sources);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GroupCallParticipantVideoSourceGroup.super.identifier();
    }

    private ImmutableGroupCallParticipantVideoSourceGroup(int identifier, String semantics, List<Integer> sources) {
        this.identifier = identifier;
        this.semantics = semantics;
        this.sources = sources;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String semantics() {
        return this.semantics;
    }

    @Override
    public List<Integer> sources() {
        return this.sources;
    }

    public final ImmutableGroupCallParticipantVideoSourceGroup withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideoSourceGroup(value, this.semantics, this.sources);
    }

    public final ImmutableGroupCallParticipantVideoSourceGroup withSemantics(String value) {
        String newValue = Objects.requireNonNull(value, "semantics");
        if (this.semantics.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupCallParticipantVideoSourceGroup(this.identifier, newValue, this.sources);
    }

    public final ImmutableGroupCallParticipantVideoSourceGroup withSources(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableGroupCallParticipantVideoSourceGroup.createUnmodifiableList(false, wrappedList);
        return new ImmutableGroupCallParticipantVideoSourceGroup(this.identifier, this.semantics, newValue);
    }

    public final ImmutableGroupCallParticipantVideoSourceGroup withSources(Iterable<Integer> elements) {
        if (this.sources == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableGroupCallParticipantVideoSourceGroup.createUnmodifiableList(false, ImmutableGroupCallParticipantVideoSourceGroup.createSafeList(elements, true, false));
        return new ImmutableGroupCallParticipantVideoSourceGroup(this.identifier, this.semantics, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallParticipantVideoSourceGroup && this.equalTo(0, (ImmutableGroupCallParticipantVideoSourceGroup)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallParticipantVideoSourceGroup another) {
        return this.identifier == another.identifier && this.semantics.equals(another.semantics) && this.sources.equals(another.sources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.semantics.hashCode();
        h += (h << 5) + this.sources.hashCode();
        return h;
    }

    public String toString() {
        return "GroupCallParticipantVideoSourceGroup{identifier=" + this.identifier + ", semantics=" + this.semantics + ", sources=" + this.sources + "}";
    }

    public static ImmutableGroupCallParticipantVideoSourceGroup of(String semantics) {
        return new ImmutableGroupCallParticipantVideoSourceGroup(semantics);
    }

    public static ImmutableGroupCallParticipantVideoSourceGroup copyOf(GroupCallParticipantVideoSourceGroup instance) {
        if (instance instanceof ImmutableGroupCallParticipantVideoSourceGroup) {
            return (ImmutableGroupCallParticipantVideoSourceGroup)instance;
        }
        return ImmutableGroupCallParticipantVideoSourceGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SEMANTICS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String semantics;
        private List<Integer> sources = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(GroupCallParticipantVideoSourceGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCallParticipantVideoSourceGroup instance;
            long bits = 0L;
            if (object instanceof GroupCallParticipantVideoSourceGroup) {
                instance = (GroupCallParticipantVideoSourceGroup)object;
                this.addAllSources(instance.sources());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.semantics(instance.semantics());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder semantics(String semantics) {
            this.semantics = Objects.requireNonNull(semantics, "semantics");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSource(int element) {
            this.sources.add(element);
            return this;
        }

        public final Builder addSources(int ... elements) {
            for (int element : elements) {
                this.sources.add(element);
            }
            return this;
        }

        public final Builder sources(Iterable<Integer> elements) {
            this.sources.clear();
            return this.addAllSources(elements);
        }

        public final Builder addAllSources(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        public ImmutableGroupCallParticipantVideoSourceGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCallParticipantVideoSourceGroup(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("semantics");
            }
            return "Cannot build GroupCallParticipantVideoSourceGroup, some of required attributes are not set " + attributes;
        }
    }
}

