/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.GroupCallStreamChannel;
import telegram4j.tl.api.TlObject;

public final class ImmutableGroupCallStreamChannel
implements GroupCallStreamChannel {
    private final int identifier;
    private final int channel;
    private final int scale;
    private final long lastTimestampMs;

    private ImmutableGroupCallStreamChannel(int channel, int scale, long lastTimestampMs) {
        this.channel = channel;
        this.scale = scale;
        this.lastTimestampMs = lastTimestampMs;
        this.identifier = GroupCallStreamChannel.super.identifier();
    }

    private ImmutableGroupCallStreamChannel(Builder builder) {
        this.channel = builder.channel;
        this.scale = builder.scale;
        this.lastTimestampMs = builder.lastTimestampMs;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GroupCallStreamChannel.super.identifier();
    }

    private ImmutableGroupCallStreamChannel(int identifier, int channel, int scale, long lastTimestampMs) {
        this.identifier = identifier;
        this.channel = channel;
        this.scale = scale;
        this.lastTimestampMs = lastTimestampMs;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int channel() {
        return this.channel;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public long lastTimestampMs() {
        return this.lastTimestampMs;
    }

    public final ImmutableGroupCallStreamChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallStreamChannel(value, this.channel, this.scale, this.lastTimestampMs);
    }

    public final ImmutableGroupCallStreamChannel withChannel(int value) {
        if (this.channel == value) {
            return this;
        }
        return new ImmutableGroupCallStreamChannel(this.identifier, value, this.scale, this.lastTimestampMs);
    }

    public final ImmutableGroupCallStreamChannel withScale(int value) {
        if (this.scale == value) {
            return this;
        }
        return new ImmutableGroupCallStreamChannel(this.identifier, this.channel, value, this.lastTimestampMs);
    }

    public final ImmutableGroupCallStreamChannel withLastTimestampMs(long value) {
        if (this.lastTimestampMs == value) {
            return this;
        }
        return new ImmutableGroupCallStreamChannel(this.identifier, this.channel, this.scale, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallStreamChannel && this.equalTo(0, (ImmutableGroupCallStreamChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallStreamChannel another) {
        return this.identifier == another.identifier && this.channel == another.channel && this.scale == another.scale && this.lastTimestampMs == another.lastTimestampMs;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel;
        h += (h << 5) + this.scale;
        h += (h << 5) + Long.hashCode(this.lastTimestampMs);
        return h;
    }

    public String toString() {
        return "GroupCallStreamChannel{identifier=" + this.identifier + ", channel=" + this.channel + ", scale=" + this.scale + ", lastTimestampMs=" + this.lastTimestampMs + "}";
    }

    public static ImmutableGroupCallStreamChannel of(int channel, int scale, long lastTimestampMs) {
        return new ImmutableGroupCallStreamChannel(channel, scale, lastTimestampMs);
    }

    public static ImmutableGroupCallStreamChannel copyOf(GroupCallStreamChannel instance) {
        if (instance instanceof ImmutableGroupCallStreamChannel) {
            return (ImmutableGroupCallStreamChannel)instance;
        }
        return ImmutableGroupCallStreamChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_SCALE = 2L;
        private static final long INIT_BIT_LAST_TIMESTAMP_MS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int channel;
        private int scale;
        private long lastTimestampMs;

        private Builder() {
        }

        public final Builder from(GroupCallStreamChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCallStreamChannel instance;
            long bits = 0L;
            if (object instanceof GroupCallStreamChannel) {
                instance = (GroupCallStreamChannel)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.scale(instance.scale());
                this.lastTimestampMs(instance.lastTimestampMs());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(int channel) {
            this.channel = channel;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scale(int scale) {
            this.scale = scale;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastTimestampMs(long lastTimestampMs) {
            this.lastTimestampMs = lastTimestampMs;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGroupCallStreamChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCallStreamChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scale");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastTimestampMs");
            }
            return "Cannot build GroupCallStreamChannel, some of required attributes are not set " + attributes;
        }
    }
}

