/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.HighScore;
import telegram4j.tl.api.TlObject;

public final class ImmutableHighScore
implements HighScore {
    private final int identifier;
    private final int pos;
    private final long userId;
    private final int score;

    private ImmutableHighScore(int pos, long userId, int score) {
        this.pos = pos;
        this.userId = userId;
        this.score = score;
        this.identifier = HighScore.super.identifier();
    }

    private ImmutableHighScore(Builder builder) {
        this.pos = builder.pos;
        this.userId = builder.userId;
        this.score = builder.score;
        this.identifier = builder.identifierIsSet() ? builder.identifier : HighScore.super.identifier();
    }

    private ImmutableHighScore(int identifier, int pos, long userId, int score) {
        this.identifier = identifier;
        this.pos = pos;
        this.userId = userId;
        this.score = score;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int score() {
        return this.score;
    }

    public final ImmutableHighScore withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableHighScore(value, this.pos, this.userId, this.score);
    }

    public final ImmutableHighScore withPos(int value) {
        if (this.pos == value) {
            return this;
        }
        return new ImmutableHighScore(this.identifier, value, this.userId, this.score);
    }

    public final ImmutableHighScore withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableHighScore(this.identifier, this.pos, value, this.score);
    }

    public final ImmutableHighScore withScore(int value) {
        if (this.score == value) {
            return this;
        }
        return new ImmutableHighScore(this.identifier, this.pos, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHighScore && this.equalTo(0, (ImmutableHighScore)another);
    }

    private boolean equalTo(int synthetic, ImmutableHighScore another) {
        return this.identifier == another.identifier && this.pos == another.pos && this.userId == another.userId && this.score == another.score;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pos;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.score;
        return h;
    }

    public String toString() {
        return "HighScore{identifier=" + this.identifier + ", pos=" + this.pos + ", userId=" + this.userId + ", score=" + this.score + "}";
    }

    public static ImmutableHighScore of(int pos, long userId, int score) {
        return new ImmutableHighScore(pos, userId, score);
    }

    public static ImmutableHighScore copyOf(HighScore instance) {
        if (instance instanceof ImmutableHighScore) {
            return (ImmutableHighScore)instance;
        }
        return ImmutableHighScore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_POS = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_SCORE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int pos;
        private long userId;
        private int score;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HighScore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof HighScore) {
                instance = (HighScore)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.score(instance.score());
                this.pos(instance.pos());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pos(int pos) {
            this.pos = pos;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder score(int score) {
            this.score = score;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableHighScore build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHighScore(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pos");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("score");
            }
            return "Cannot build HighScore, some of required attributes are not set " + attributes;
        }
    }
}

