/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ImportedContact;
import telegram4j.tl.api.TlObject;

public final class ImmutableImportedContact
implements ImportedContact {
    private final int identifier;
    private final long userId;
    private final long clientId;

    private ImmutableImportedContact(long userId, long clientId) {
        this.userId = userId;
        this.clientId = clientId;
        this.identifier = ImportedContact.super.identifier();
    }

    private ImmutableImportedContact(Builder builder) {
        this.userId = builder.userId;
        this.clientId = builder.clientId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ImportedContact.super.identifier();
    }

    private ImmutableImportedContact(int identifier, long userId, long clientId) {
        this.identifier = identifier;
        this.userId = userId;
        this.clientId = clientId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public long clientId() {
        return this.clientId;
    }

    public final ImmutableImportedContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableImportedContact(value, this.userId, this.clientId);
    }

    public final ImmutableImportedContact withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableImportedContact(this.identifier, value, this.clientId);
    }

    public final ImmutableImportedContact withClientId(long value) {
        if (this.clientId == value) {
            return this;
        }
        return new ImmutableImportedContact(this.identifier, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportedContact && this.equalTo(0, (ImmutableImportedContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableImportedContact another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.clientId == another.clientId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Long.hashCode(this.clientId);
        return h;
    }

    public String toString() {
        return "ImportedContact{identifier=" + this.identifier + ", userId=" + this.userId + ", clientId=" + this.clientId + "}";
    }

    public static ImmutableImportedContact of(long userId, long clientId) {
        return new ImmutableImportedContact(userId, clientId);
    }

    public static ImmutableImportedContact copyOf(ImportedContact instance) {
        if (instance instanceof ImmutableImportedContact) {
            return (ImmutableImportedContact)instance;
        }
        return ImmutableImportedContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_CLIENT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private long clientId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ImportedContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ImportedContact) {
                instance = (ImportedContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                this.clientId(instance.clientId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientId(long clientId) {
            this.clientId = clientId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableImportedContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImportedContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build ImportedContact, some of required attributes are not set " + attributes;
        }
    }
}

