/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InlineBotSwitchPM;
import telegram4j.tl.api.TlObject;

public final class ImmutableInlineBotSwitchPM
implements InlineBotSwitchPM {
    private final int identifier;
    private final String text;
    private final String startParam;

    private ImmutableInlineBotSwitchPM(String text, String startParam) {
        this.text = Objects.requireNonNull(text, "text");
        this.startParam = Objects.requireNonNull(startParam, "startParam");
        this.identifier = InlineBotSwitchPM.super.identifier();
    }

    private ImmutableInlineBotSwitchPM(Builder builder) {
        this.text = builder.text;
        this.startParam = builder.startParam;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InlineBotSwitchPM.super.identifier();
    }

    private ImmutableInlineBotSwitchPM(int identifier, String text, String startParam) {
        this.identifier = identifier;
        this.text = text;
        this.startParam = startParam;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public String startParam() {
        return this.startParam;
    }

    public final ImmutableInlineBotSwitchPM withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInlineBotSwitchPM(value, this.text, this.startParam);
    }

    public final ImmutableInlineBotSwitchPM withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableInlineBotSwitchPM(this.identifier, newValue, this.startParam);
    }

    public final ImmutableInlineBotSwitchPM withStartParam(String value) {
        String newValue = Objects.requireNonNull(value, "startParam");
        if (this.startParam.equals(newValue)) {
            return this;
        }
        return new ImmutableInlineBotSwitchPM(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInlineBotSwitchPM && this.equalTo(0, (ImmutableInlineBotSwitchPM)another);
    }

    private boolean equalTo(int synthetic, ImmutableInlineBotSwitchPM another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.startParam.equals(another.startParam);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.startParam.hashCode();
        return h;
    }

    public String toString() {
        return "InlineBotSwitchPM{identifier=" + this.identifier + ", text=" + this.text + ", startParam=" + this.startParam + "}";
    }

    public static ImmutableInlineBotSwitchPM of(String text, String startParam) {
        return new ImmutableInlineBotSwitchPM(text, startParam);
    }

    public static ImmutableInlineBotSwitchPM copyOf(InlineBotSwitchPM instance) {
        if (instance instanceof ImmutableInlineBotSwitchPM) {
            return (ImmutableInlineBotSwitchPM)instance;
        }
        return ImmutableInlineBotSwitchPM.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_START_PARAM = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String text;
        private String startParam;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InlineBotSwitchPM instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InlineBotSwitchPM) {
                instance = (InlineBotSwitchPM)object;
                this.startParam(instance.startParam());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder startParam(String startParam) {
            this.startParam = Objects.requireNonNull(startParam, "startParam");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInlineBotSwitchPM build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInlineBotSwitchPM(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("startParam");
            }
            return "Cannot build InlineBotSwitchPM, some of required attributes are not set " + attributes;
        }
    }
}

