/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputAppEvent;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputAppEvent
implements InputAppEvent {
    private final int identifier;
    private final double time;
    private final String type;
    private final long peer;
    private final JsonNode data;

    private ImmutableInputAppEvent(double time, String type, long peer, JsonNode data) {
        this.time = time;
        this.type = Objects.requireNonNull(type, "type");
        this.peer = peer;
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = InputAppEvent.super.identifier();
    }

    private ImmutableInputAppEvent(Builder builder) {
        this.time = builder.time;
        this.type = builder.type;
        this.peer = builder.peer;
        this.data = builder.data;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputAppEvent.super.identifier();
    }

    private ImmutableInputAppEvent(int identifier, double time, String type, long peer, JsonNode data) {
        this.identifier = identifier;
        this.time = time;
        this.type = type;
        this.peer = peer;
        this.data = data;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public double time() {
        return this.time;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public long peer() {
        return this.peer;
    }

    @Override
    public JsonNode data() {
        return this.data;
    }

    public final ImmutableInputAppEvent withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputAppEvent(value, this.time, this.type, this.peer, this.data);
    }

    public final ImmutableInputAppEvent withTime(double value) {
        if (Double.doubleToLongBits(this.time) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableInputAppEvent(this.identifier, value, this.type, this.peer, this.data);
    }

    public final ImmutableInputAppEvent withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableInputAppEvent(this.identifier, this.time, newValue, this.peer, this.data);
    }

    public final ImmutableInputAppEvent withPeer(long value) {
        if (this.peer == value) {
            return this;
        }
        return new ImmutableInputAppEvent(this.identifier, this.time, this.type, value, this.data);
    }

    public final ImmutableInputAppEvent withData(JsonNode value) {
        if (this.data == value) {
            return this;
        }
        JsonNode newValue = Objects.requireNonNull(value, "data");
        return new ImmutableInputAppEvent(this.identifier, this.time, this.type, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputAppEvent && this.equalTo(0, (ImmutableInputAppEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputAppEvent another) {
        return this.identifier == another.identifier && Double.doubleToLongBits(this.time) == Double.doubleToLongBits(another.time) && this.type.equals(another.type) && this.peer == another.peer && this.data.equals((Object)another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Double.hashCode(this.time);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Long.hashCode(this.peer);
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "InputAppEvent{identifier=" + this.identifier + ", time=" + this.time + ", type=" + this.type + ", peer=" + this.peer + ", data=" + this.data + "}";
    }

    public static ImmutableInputAppEvent of(double time, String type, long peer, JsonNode data) {
        return new ImmutableInputAppEvent(time, type, peer, data);
    }

    public static ImmutableInputAppEvent copyOf(InputAppEvent instance) {
        if (instance instanceof ImmutableInputAppEvent) {
            return (ImmutableInputAppEvent)instance;
        }
        return ImmutableInputAppEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TIME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_PEER = 4L;
        private static final long INIT_BIT_DATA = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private double time;
        private String type;
        private long peer;
        private JsonNode data;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputAppEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputAppEvent) {
                instance = (InputAppEvent)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.time(instance.time());
                this.data(instance.data());
                this.type(instance.type());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder time(double time) {
            this.time = time;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder peer(long peer) {
            this.peer = peer;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder data(JsonNode data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInputAppEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputAppEvent(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("time");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build InputAppEvent, some of required attributes are not set " + attributes;
        }
    }
}

