/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineMessageGame;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineMessageGame
implements InputBotInlineMessageGame {
    private final int identifier;
    private final int flags;
    @Nullable
    private final ReplyMarkup replyMarkup;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInputBotInlineMessageGame INSTANCE = ImmutableInputBotInlineMessageGame.validate(new ImmutableInputBotInlineMessageGame());

    private ImmutableInputBotInlineMessageGame() {
        this.replyMarkup = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageGame(Builder builder) {
        this.replyMarkup = builder.replyMarkup;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageGame(int identifier, int flags, @Nullable ReplyMarkup replyMarkup) {
        this.identifier = identifier;
        this.flags = flags;
        this.replyMarkup = replyMarkup;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputBotInlineMessageGame.super.identifier();
    }

    private int flagsInitialize() {
        return InputBotInlineMessageGame.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    public final ImmutableInputBotInlineMessageGame withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputBotInlineMessageGame.validate(new ImmutableInputBotInlineMessageGame(value, this.flags, this.replyMarkup));
    }

    public final ImmutableInputBotInlineMessageGame withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInputBotInlineMessageGame.validate(new ImmutableInputBotInlineMessageGame(this.identifier, value, this.replyMarkup));
    }

    public final ImmutableInputBotInlineMessageGame withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return ImmutableInputBotInlineMessageGame.validate(new ImmutableInputBotInlineMessageGame(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineMessageGame && this.equalTo(0, (ImmutableInputBotInlineMessageGame)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineMessageGame another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.replyMarkup, another.replyMarkup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        return h;
    }

    public String toString() {
        return "InputBotInlineMessageGame{identifier=" + this.identifier + ", flags=" + this.flags + ", replyMarkup=" + this.replyMarkup + "}";
    }

    public static ImmutableInputBotInlineMessageGame of() {
        return INSTANCE;
    }

    private static ImmutableInputBotInlineMessageGame validate(ImmutableInputBotInlineMessageGame instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputBotInlineMessageGame copyOf(InputBotInlineMessageGame instance) {
        if (instance instanceof ImmutableInputBotInlineMessageGame) {
            return (ImmutableInputBotInlineMessageGame)instance;
        }
        return ImmutableInputBotInlineMessageGame.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private ReplyMarkup replyMarkup;

        private Builder() {
        }

        public final Builder from(InputBotInlineMessageGame instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup replyMarkupValue;
            InputBotInlineMessage instance;
            long bits = 0L;
            if (object instanceof InputBotInlineMessageGame) {
                instance = (InputBotInlineMessageGame)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputBotInlineMessage) {
                instance = (InputBotInlineMessage)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public ImmutableInputBotInlineMessageGame build() {
            return ImmutableInputBotInlineMessageGame.validate(new ImmutableInputBotInlineMessageGame(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputBotInlineMessageGame.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputBotInlineMessageGame.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputBotInlineMessageGame, attribute initializers form cycle " + attributes;
        }
    }
}

