/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.InputBotInlineMessageID64;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineMessageID64
implements InputBotInlineMessageID64 {
    private final int identifier;
    private final int dcId;
    private final long ownerId;
    private final int id;
    private final long accessHash;

    private ImmutableInputBotInlineMessageID64(int dcId, long ownerId, int id, long accessHash) {
        this.dcId = dcId;
        this.ownerId = ownerId;
        this.id = id;
        this.accessHash = accessHash;
        this.identifier = InputBotInlineMessageID64.super.identifier();
    }

    private ImmutableInputBotInlineMessageID64(Builder builder) {
        this.dcId = builder.dcId;
        this.ownerId = builder.ownerId;
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputBotInlineMessageID64.super.identifier();
    }

    private ImmutableInputBotInlineMessageID64(int identifier, int dcId, long ownerId, int id, long accessHash) {
        this.identifier = identifier;
        this.dcId = dcId;
        this.ownerId = ownerId;
        this.id = id;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public long ownerId() {
        return this.ownerId;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableInputBotInlineMessageID64 withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageID64(value, this.dcId, this.ownerId, this.id, this.accessHash);
    }

    public final ImmutableInputBotInlineMessageID64 withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageID64(this.identifier, value, this.ownerId, this.id, this.accessHash);
    }

    public final ImmutableInputBotInlineMessageID64 withOwnerId(long value) {
        if (this.ownerId == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageID64(this.identifier, this.dcId, value, this.id, this.accessHash);
    }

    public final ImmutableInputBotInlineMessageID64 withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageID64(this.identifier, this.dcId, this.ownerId, value, this.accessHash);
    }

    public final ImmutableInputBotInlineMessageID64 withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageID64(this.identifier, this.dcId, this.ownerId, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineMessageID64 && this.equalTo(0, (ImmutableInputBotInlineMessageID64)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineMessageID64 another) {
        return this.identifier == another.identifier && this.dcId == another.dcId && this.ownerId == another.ownerId && this.id == another.id && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcId;
        h += (h << 5) + Long.hashCode(this.ownerId);
        h += (h << 5) + this.id;
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "InputBotInlineMessageID64{identifier=" + this.identifier + ", dcId=" + this.dcId + ", ownerId=" + this.ownerId + ", id=" + this.id + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableInputBotInlineMessageID64 of(int dcId, long ownerId, int id, long accessHash) {
        return new ImmutableInputBotInlineMessageID64(dcId, ownerId, id, accessHash);
    }

    public static ImmutableInputBotInlineMessageID64 copyOf(InputBotInlineMessageID64 instance) {
        if (instance instanceof ImmutableInputBotInlineMessageID64) {
            return (ImmutableInputBotInlineMessageID64)instance;
        }
        return ImmutableInputBotInlineMessageID64.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DC_ID = 1L;
        private static final long INIT_BIT_OWNER_ID = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_ACCESS_HASH = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int dcId;
        private long ownerId;
        private int id;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(InputBotInlineMessageID instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineMessageID64 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputBotInlineMessageID instance;
            long bits = 0L;
            if (object instanceof InputBotInlineMessageID) {
                instance = (InputBotInlineMessageID)object;
                if ((bits & 2L) == 0L) {
                    this.dcId(instance.dcId());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 4L;
                }
            }
            if (object instanceof InputBotInlineMessageID64) {
                instance = (InputBotInlineMessageID64)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 4L;
                }
                this.id(instance.id());
                if ((bits & 2L) == 0L) {
                    this.dcId(instance.dcId());
                    bits |= 2L;
                }
                this.ownerId(instance.ownerId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ownerId(long ownerId) {
            this.ownerId = ownerId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInputBotInlineMessageID64 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputBotInlineMessageID64(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dcId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ownerId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build InputBotInlineMessageID64, some of required attributes are not set " + attributes;
        }
    }
}

