/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineMessageMediaGeo;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineMessageMediaGeo
implements InputBotInlineMessageMediaGeo {
    private final int identifier;
    private final int flags;
    private final InputGeoPoint geoPoint;
    @Nullable
    private final Integer heading;
    @Nullable
    private final Integer period;
    @Nullable
    private final Integer proximityNotificationRadius;
    @Nullable
    private final ReplyMarkup replyMarkup;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputBotInlineMessageMediaGeo(InputGeoPoint geoPoint) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.heading = null;
        this.period = null;
        this.proximityNotificationRadius = null;
        this.replyMarkup = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageMediaGeo(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.heading = builder.heading;
        this.period = builder.period;
        this.proximityNotificationRadius = builder.proximityNotificationRadius;
        this.replyMarkup = builder.replyMarkup;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageMediaGeo(int identifier, int flags, InputGeoPoint geoPoint, @Nullable Integer heading, @Nullable Integer period, @Nullable Integer proximityNotificationRadius, @Nullable ReplyMarkup replyMarkup) {
        this.identifier = identifier;
        this.flags = flags;
        this.geoPoint = geoPoint;
        this.heading = heading;
        this.period = period;
        this.proximityNotificationRadius = proximityNotificationRadius;
        this.replyMarkup = replyMarkup;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputBotInlineMessageMediaGeo.super.identifier();
    }

    private int flagsInitialize() {
        return InputBotInlineMessageMediaGeo.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    @Nullable
    public Integer heading() {
        return this.heading;
    }

    @Override
    @Nullable
    public Integer period() {
        return this.period;
    }

    @Override
    @Nullable
    public Integer proximityNotificationRadius() {
        return this.proximityNotificationRadius;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    public final ImmutableInputBotInlineMessageMediaGeo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaGeo(value, this.flags, this.geoPoint, this.heading, this.period, this.proximityNotificationRadius, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaGeo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaGeo(this.identifier, value, this.geoPoint, this.heading, this.period, this.proximityNotificationRadius, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaGeo withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableInputBotInlineMessageMediaGeo(this.identifier, this.flags, newValue, this.heading, this.period, this.proximityNotificationRadius, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaGeo withHeading(@Nullable Integer value) {
        if (Objects.equals(this.heading, value)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaGeo(this.identifier, this.flags, this.geoPoint, value, this.period, this.proximityNotificationRadius, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaGeo withPeriod(@Nullable Integer value) {
        if (Objects.equals(this.period, value)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaGeo(this.identifier, this.flags, this.geoPoint, this.heading, value, this.proximityNotificationRadius, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaGeo withProximityNotificationRadius(@Nullable Integer value) {
        if (Objects.equals(this.proximityNotificationRadius, value)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaGeo(this.identifier, this.flags, this.geoPoint, this.heading, this.period, value, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaGeo withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaGeo(this.identifier, this.flags, this.geoPoint, this.heading, this.period, this.proximityNotificationRadius, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineMessageMediaGeo && this.equalTo(0, (ImmutableInputBotInlineMessageMediaGeo)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineMessageMediaGeo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.geoPoint.equals(another.geoPoint) && Objects.equals(this.heading, another.heading) && Objects.equals(this.period, another.period) && Objects.equals(this.proximityNotificationRadius, another.proximityNotificationRadius) && Objects.equals(this.replyMarkup, another.replyMarkup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + Objects.hashCode(this.heading);
        h += (h << 5) + Objects.hashCode(this.period);
        h += (h << 5) + Objects.hashCode(this.proximityNotificationRadius);
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        return h;
    }

    public String toString() {
        return "InputBotInlineMessageMediaGeo{identifier=" + this.identifier + ", flags=" + this.flags + ", geoPoint=" + this.geoPoint + ", heading=" + this.heading + ", period=" + this.period + ", proximityNotificationRadius=" + this.proximityNotificationRadius + ", replyMarkup=" + this.replyMarkup + "}";
    }

    public static ImmutableInputBotInlineMessageMediaGeo of(InputGeoPoint geoPoint) {
        return new ImmutableInputBotInlineMessageMediaGeo(geoPoint);
    }

    public static ImmutableInputBotInlineMessageMediaGeo copyOf(InputBotInlineMessageMediaGeo instance) {
        if (instance instanceof ImmutableInputBotInlineMessageMediaGeo) {
            return (ImmutableInputBotInlineMessageMediaGeo)instance;
        }
        return ImmutableInputBotInlineMessageMediaGeo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputGeoPoint geoPoint;
        private Integer heading;
        private Integer period;
        private Integer proximityNotificationRadius;
        private ReplyMarkup replyMarkup;

        private Builder() {
        }

        public final Builder from(InputBotInlineMessageMediaGeo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputBotInlineMessage instance;
            long bits = 0L;
            if (object instanceof InputBotInlineMessageMediaGeo) {
                Integer headingValue;
                Integer periodValue;
                instance = (InputBotInlineMessageMediaGeo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((periodValue = instance.period()) != null) {
                    this.period(periodValue);
                }
                if ((headingValue = instance.heading()) != null) {
                    this.heading(headingValue);
                }
                if ((bits & 2L) == 0L) {
                    ReplyMarkup replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                this.geoPoint(instance.geoPoint());
                Integer proximityNotificationRadiusValue = instance.proximityNotificationRadius();
                if (proximityNotificationRadiusValue != null) {
                    this.proximityNotificationRadius(proximityNotificationRadiusValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputBotInlineMessage) {
                instance = (InputBotInlineMessage)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ReplyMarkup replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder heading(@Nullable Integer heading) {
            this.heading = heading;
            return this;
        }

        public final Builder period(@Nullable Integer period) {
            this.period = period;
            return this;
        }

        public final Builder proximityNotificationRadius(@Nullable Integer proximityNotificationRadius) {
            this.proximityNotificationRadius = proximityNotificationRadius;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public ImmutableInputBotInlineMessageMediaGeo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputBotInlineMessageMediaGeo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            return "Cannot build InputBotInlineMessageMediaGeo, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputBotInlineMessageMediaGeo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputBotInlineMessageMediaGeo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputBotInlineMessageMediaGeo, attribute initializers form cycle " + attributes;
        }
    }
}

