/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineMessageMediaVenue;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineMessageMediaVenue
implements InputBotInlineMessageMediaVenue {
    private final int identifier;
    private final int flags;
    private final InputGeoPoint geoPoint;
    private final String title;
    private final String address;
    private final String provider;
    private final String venueId;
    private final String venueType;
    @Nullable
    private final ReplyMarkup replyMarkup;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputBotInlineMessageMediaVenue(InputGeoPoint geoPoint, String title, String address, String provider, String venueId, String venueType) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.title = Objects.requireNonNull(title, "title");
        this.address = Objects.requireNonNull(address, "address");
        this.provider = Objects.requireNonNull(provider, "provider");
        this.venueId = Objects.requireNonNull(venueId, "venueId");
        this.venueType = Objects.requireNonNull(venueType, "venueType");
        this.replyMarkup = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageMediaVenue(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.title = builder.title;
        this.address = builder.address;
        this.provider = builder.provider;
        this.venueId = builder.venueId;
        this.venueType = builder.venueType;
        this.replyMarkup = builder.replyMarkup;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageMediaVenue(int identifier, int flags, InputGeoPoint geoPoint, String title, String address, String provider, String venueId, String venueType, @Nullable ReplyMarkup replyMarkup) {
        this.identifier = identifier;
        this.flags = flags;
        this.geoPoint = geoPoint;
        this.title = title;
        this.address = address;
        this.provider = provider;
        this.venueId = venueId;
        this.venueType = venueType;
        this.replyMarkup = replyMarkup;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputBotInlineMessageMediaVenue.super.identifier();
    }

    private int flagsInitialize() {
        return InputBotInlineMessageMediaVenue.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String venueId() {
        return this.venueId;
    }

    @Override
    public String venueType() {
        return this.venueType;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    public final ImmutableInputBotInlineMessageMediaVenue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(value, this.flags, this.geoPoint, this.title, this.address, this.provider, this.venueId, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, value, this.geoPoint, this.title, this.address, this.provider, this.venueId, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, newValue, this.title, this.address, this.provider, this.venueId, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, this.geoPoint, newValue, this.address, this.provider, this.venueId, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, this.geoPoint, this.title, newValue, this.provider, this.venueId, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withProvider(String value) {
        String newValue = Objects.requireNonNull(value, "provider");
        if (this.provider.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, this.geoPoint, this.title, this.address, newValue, this.venueId, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withVenueId(String value) {
        String newValue = Objects.requireNonNull(value, "venueId");
        if (this.venueId.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, this.geoPoint, this.title, this.address, this.provider, newValue, this.venueType, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withVenueType(String value) {
        String newValue = Objects.requireNonNull(value, "venueType");
        if (this.venueType.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, this.geoPoint, this.title, this.address, this.provider, this.venueId, newValue, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageMediaVenue withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageMediaVenue(this.identifier, this.flags, this.geoPoint, this.title, this.address, this.provider, this.venueId, this.venueType, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineMessageMediaVenue && this.equalTo(0, (ImmutableInputBotInlineMessageMediaVenue)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineMessageMediaVenue another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.geoPoint.equals(another.geoPoint) && this.title.equals(another.title) && this.address.equals(another.address) && this.provider.equals(another.provider) && this.venueId.equals(another.venueId) && this.venueType.equals(another.venueType) && Objects.equals(this.replyMarkup, another.replyMarkup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.venueId.hashCode();
        h += (h << 5) + this.venueType.hashCode();
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        return h;
    }

    public String toString() {
        return "InputBotInlineMessageMediaVenue{identifier=" + this.identifier + ", flags=" + this.flags + ", geoPoint=" + this.geoPoint + ", title=" + this.title + ", address=" + this.address + ", provider=" + this.provider + ", venueId=" + this.venueId + ", venueType=" + this.venueType + ", replyMarkup=" + this.replyMarkup + "}";
    }

    public static ImmutableInputBotInlineMessageMediaVenue of(InputGeoPoint geoPoint, String title, String address, String provider, String venueId, String venueType) {
        return new ImmutableInputBotInlineMessageMediaVenue(geoPoint, title, address, provider, venueId, venueType);
    }

    public static ImmutableInputBotInlineMessageMediaVenue copyOf(InputBotInlineMessageMediaVenue instance) {
        if (instance instanceof ImmutableInputBotInlineMessageMediaVenue) {
            return (ImmutableInputBotInlineMessageMediaVenue)instance;
        }
        return ImmutableInputBotInlineMessageMediaVenue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_PROVIDER = 8L;
        private static final long INIT_BIT_VENUE_ID = 16L;
        private static final long INIT_BIT_VENUE_TYPE = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputGeoPoint geoPoint;
        private String title;
        private String address;
        private String provider;
        private String venueId;
        private String venueType;
        private ReplyMarkup replyMarkup;

        private Builder() {
        }

        public final Builder from(InputBotInlineMessageMediaVenue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup replyMarkupValue;
            InputBotInlineMessage instance;
            long bits = 0L;
            if (object instanceof InputBotInlineMessageMediaVenue) {
                instance = (InputBotInlineMessageMediaVenue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.address(instance.address());
                this.venueType(instance.venueType());
                this.provider(instance.provider());
                if ((bits & 2L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
                this.venueId(instance.venueId());
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                this.geoPoint(instance.geoPoint());
                this.title(instance.title());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputBotInlineMessage) {
                instance = (InputBotInlineMessage)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder venueId(String venueId) {
            this.venueId = Objects.requireNonNull(venueId, "venueId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder venueType(String venueType) {
            this.venueType = Objects.requireNonNull(venueType, "venueType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public ImmutableInputBotInlineMessageMediaVenue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputBotInlineMessageMediaVenue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("venueId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("venueType");
            }
            return "Cannot build InputBotInlineMessageMediaVenue, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputBotInlineMessageMediaVenue.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputBotInlineMessageMediaVenue.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputBotInlineMessageMediaVenue, attribute initializers form cycle " + attributes;
        }
    }
}

