/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineMessageText;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineMessageText
implements InputBotInlineMessageText {
    private final int identifier;
    private final int flags;
    private final boolean noWebpage;
    private final String message;
    @Nullable
    private final List<MessageEntity> entities;
    @Nullable
    private final ReplyMarkup replyMarkup;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputBotInlineMessageText(String message) {
        this.message = Objects.requireNonNull(message, "message");
        this.entities = null;
        this.replyMarkup = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageText(Builder builder) {
        this.message = builder.message;
        this.entities = builder.entities == null ? null : ImmutableInputBotInlineMessageText.createUnmodifiableList(true, builder.entities);
        this.replyMarkup = builder.replyMarkup;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.noWebpageIsSet()) {
            this.initShim.noWebpage(builder.noWebpage);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableInputBotInlineMessageText(int identifier, int flags, boolean noWebpage, String message, @Nullable List<MessageEntity> entities, @Nullable ReplyMarkup replyMarkup) {
        this.identifier = identifier;
        this.flags = flags;
        this.noWebpage = noWebpage;
        this.message = message;
        this.entities = entities;
        this.replyMarkup = replyMarkup;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputBotInlineMessageText.super.identifier();
    }

    private int flagsInitialize() {
        return InputBotInlineMessageText.super.flags();
    }

    private boolean noWebpageInitialize() {
        return InputBotInlineMessageText.super.noWebpage();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean noWebpage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noWebpage() : this.noWebpage;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    public final ImmutableInputBotInlineMessageText withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageText(value, this.flags, this.noWebpage, this.message, this.entities, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageText withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageText(this.identifier, value, this.noWebpage, this.message, this.entities, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageText withNoWebpage(boolean value) {
        if (this.noWebpage == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageText(this.identifier, this.flags, value, this.message, this.entities, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageText withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineMessageText(this.identifier, this.flags, this.noWebpage, newValue, this.entities, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageText withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableInputBotInlineMessageText(this.identifier, this.flags, this.noWebpage, this.message, null, this.replyMarkup);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableInputBotInlineMessageText.createUnmodifiableList(false, ImmutableInputBotInlineMessageText.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputBotInlineMessageText(this.identifier, this.flags, this.noWebpage, this.message, newValue, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageText withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableInputBotInlineMessageText.createUnmodifiableList(false, ImmutableInputBotInlineMessageText.createSafeList(elements, true, false));
        return new ImmutableInputBotInlineMessageText(this.identifier, this.flags, this.noWebpage, this.message, newValue, this.replyMarkup);
    }

    public final ImmutableInputBotInlineMessageText withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableInputBotInlineMessageText(this.identifier, this.flags, this.noWebpage, this.message, this.entities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineMessageText && this.equalTo(0, (ImmutableInputBotInlineMessageText)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineMessageText another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.noWebpage == another.noWebpage && this.message.equals(another.message) && Objects.equals(this.entities, another.entities) && Objects.equals(this.replyMarkup, another.replyMarkup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.noWebpage);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        return h;
    }

    public String toString() {
        return "InputBotInlineMessageText{identifier=" + this.identifier + ", flags=" + this.flags + ", noWebpage=" + this.noWebpage + ", message=" + this.message + ", entities=" + this.entities + ", replyMarkup=" + this.replyMarkup + "}";
    }

    public static ImmutableInputBotInlineMessageText of(String message) {
        return new ImmutableInputBotInlineMessageText(message);
    }

    public static ImmutableInputBotInlineMessageText copyOf(InputBotInlineMessageText instance) {
        if (instance instanceof ImmutableInputBotInlineMessageText) {
            return (ImmutableInputBotInlineMessageText)instance;
        }
        return ImmutableInputBotInlineMessageText.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NO_WEBPAGE = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean noWebpage;
        private String message;
        private List<MessageEntity> entities = null;
        private ReplyMarkup replyMarkup;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineMessageText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputBotInlineMessageText) {
                instance = (InputBotInlineMessageText)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.noWebpage(instance.noWebpage());
                this.message(instance.message());
                List<MessageEntity> entitiesValue = instance.entities();
                if (entitiesValue != null) {
                    this.addAllEntities(entitiesValue);
                }
                if ((bits & 2L) == 0L) {
                    ReplyMarkup replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof InputBotInlineMessage) {
                instance = (InputBotInlineMessage)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ReplyMarkup replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public ImmutableInputBotInlineMessageText build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputBotInlineMessageText(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noWebpageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build InputBotInlineMessageText, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte noWebpageBuildStage = 0;
        private boolean noWebpage;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputBotInlineMessageText.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputBotInlineMessageText.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean noWebpage() {
            if (this.noWebpageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noWebpageBuildStage == 0) {
                this.noWebpageBuildStage = (byte)-1;
                this.noWebpage = ImmutableInputBotInlineMessageText.this.noWebpageInitialize();
                this.noWebpageBuildStage = 1;
            }
            return this.noWebpage;
        }

        void noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.noWebpageBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.noWebpageBuildStage == -1) {
                attributes.add("noWebpage");
            }
            return "Cannot build InputBotInlineMessageText, attribute initializers form cycle " + attributes;
        }
    }
}

