/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineResult;
import telegram4j.tl.InputBotInlineResultGame;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineResultGame
implements InputBotInlineResultGame {
    private final int identifier;
    private final String id;
    private final String shortName;
    private final InputBotInlineMessage sendMessage;

    private ImmutableInputBotInlineResultGame(String id, String shortName, InputBotInlineMessage sendMessage) {
        this.id = Objects.requireNonNull(id, "id");
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
        this.identifier = InputBotInlineResultGame.super.identifier();
    }

    private ImmutableInputBotInlineResultGame(Builder builder) {
        this.id = builder.id;
        this.shortName = builder.shortName;
        this.sendMessage = builder.sendMessage;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputBotInlineResultGame.super.identifier();
    }

    private ImmutableInputBotInlineResultGame(int identifier, String id, String shortName, InputBotInlineMessage sendMessage) {
        this.identifier = identifier;
        this.id = id;
        this.shortName = shortName;
        this.sendMessage = sendMessage;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public InputBotInlineMessage sendMessage() {
        return this.sendMessage;
    }

    public final ImmutableInputBotInlineResultGame withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputBotInlineResultGame(value, this.id, this.shortName, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultGame withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineResultGame(this.identifier, newValue, this.shortName, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultGame withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineResultGame(this.identifier, this.id, newValue, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultGame withSendMessage(InputBotInlineMessage value) {
        if (this.sendMessage == value) {
            return this;
        }
        InputBotInlineMessage newValue = Objects.requireNonNull(value, "sendMessage");
        return new ImmutableInputBotInlineResultGame(this.identifier, this.id, this.shortName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineResultGame && this.equalTo(0, (ImmutableInputBotInlineResultGame)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineResultGame another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.shortName.equals(another.shortName) && this.sendMessage.equals(another.sendMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.shortName.hashCode();
        h += (h << 5) + this.sendMessage.hashCode();
        return h;
    }

    public String toString() {
        return "InputBotInlineResultGame{identifier=" + this.identifier + ", id=" + this.id + ", shortName=" + this.shortName + ", sendMessage=" + this.sendMessage + "}";
    }

    public static ImmutableInputBotInlineResultGame of(String id, String shortName, InputBotInlineMessage sendMessage) {
        return new ImmutableInputBotInlineResultGame(id, shortName, sendMessage);
    }

    public static ImmutableInputBotInlineResultGame copyOf(InputBotInlineResultGame instance) {
        if (instance instanceof ImmutableInputBotInlineResultGame) {
            return (ImmutableInputBotInlineResultGame)instance;
        }
        return ImmutableInputBotInlineResultGame.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SHORT_NAME = 2L;
        private static final long INIT_BIT_SEND_MESSAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String id;
        private String shortName;
        private InputBotInlineMessage sendMessage;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineResultGame instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputBotInlineResultGame) {
                instance = (InputBotInlineResultGame)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
                this.shortName(instance.shortName());
            }
            if (object instanceof InputBotInlineResult) {
                instance = (InputBotInlineResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder sendMessage(InputBotInlineMessage sendMessage) {
            this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputBotInlineResultGame build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputBotInlineResultGame(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("shortName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sendMessage");
            }
            return "Cannot build InputBotInlineResultGame, some of required attributes are not set " + attributes;
        }
    }
}

