/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputBotInlineMessage;
import telegram4j.tl.InputBotInlineResult;
import telegram4j.tl.InputBotInlineResultPhoto;
import telegram4j.tl.InputPhoto;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputBotInlineResultPhoto
implements InputBotInlineResultPhoto {
    private final int identifier;
    private final String id;
    private final String type;
    private final InputPhoto photo;
    private final InputBotInlineMessage sendMessage;

    private ImmutableInputBotInlineResultPhoto(String id, String type, InputPhoto photo, InputBotInlineMessage sendMessage) {
        this.id = Objects.requireNonNull(id, "id");
        this.type = Objects.requireNonNull(type, "type");
        this.photo = Objects.requireNonNull(photo, "photo");
        this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
        this.identifier = InputBotInlineResultPhoto.super.identifier();
    }

    private ImmutableInputBotInlineResultPhoto(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.photo = builder.photo;
        this.sendMessage = builder.sendMessage;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputBotInlineResultPhoto.super.identifier();
    }

    private ImmutableInputBotInlineResultPhoto(int identifier, String id, String type, InputPhoto photo, InputBotInlineMessage sendMessage) {
        this.identifier = identifier;
        this.id = id;
        this.type = type;
        this.photo = photo;
        this.sendMessage = sendMessage;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public InputPhoto photo() {
        return this.photo;
    }

    @Override
    public InputBotInlineMessage sendMessage() {
        return this.sendMessage;
    }

    public final ImmutableInputBotInlineResultPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputBotInlineResultPhoto(value, this.id, this.type, this.photo, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultPhoto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineResultPhoto(this.identifier, newValue, this.type, this.photo, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultPhoto withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableInputBotInlineResultPhoto(this.identifier, this.id, newValue, this.photo, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultPhoto withPhoto(InputPhoto value) {
        if (this.photo == value) {
            return this;
        }
        InputPhoto newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableInputBotInlineResultPhoto(this.identifier, this.id, this.type, newValue, this.sendMessage);
    }

    public final ImmutableInputBotInlineResultPhoto withSendMessage(InputBotInlineMessage value) {
        if (this.sendMessage == value) {
            return this;
        }
        InputBotInlineMessage newValue = Objects.requireNonNull(value, "sendMessage");
        return new ImmutableInputBotInlineResultPhoto(this.identifier, this.id, this.type, this.photo, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputBotInlineResultPhoto && this.equalTo(0, (ImmutableInputBotInlineResultPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputBotInlineResultPhoto another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.type.equals(another.type) && this.photo.equals(another.photo) && this.sendMessage.equals(another.sendMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + this.sendMessage.hashCode();
        return h;
    }

    public String toString() {
        return "InputBotInlineResultPhoto{identifier=" + this.identifier + ", id=" + this.id + ", type=" + this.type + ", photo=" + this.photo + ", sendMessage=" + this.sendMessage + "}";
    }

    public static ImmutableInputBotInlineResultPhoto of(String id, String type, InputPhoto photo, InputBotInlineMessage sendMessage) {
        return new ImmutableInputBotInlineResultPhoto(id, type, photo, sendMessage);
    }

    public static ImmutableInputBotInlineResultPhoto copyOf(InputBotInlineResultPhoto instance) {
        if (instance instanceof ImmutableInputBotInlineResultPhoto) {
            return (ImmutableInputBotInlineResultPhoto)instance;
        }
        return ImmutableInputBotInlineResultPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_PHOTO = 4L;
        private static final long INIT_BIT_SEND_MESSAGE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private String id;
        private String type;
        private InputPhoto photo;
        private InputBotInlineMessage sendMessage;

        private Builder() {
        }

        public final Builder from(InputBotInlineResultPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputBotInlineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputBotInlineResult instance;
            long bits = 0L;
            if (object instanceof InputBotInlineResultPhoto) {
                instance = (InputBotInlineResultPhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.photo(instance.photo());
                if ((bits & 2L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
                this.type(instance.type());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputBotInlineResult) {
                instance = (InputBotInlineResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(InputPhoto photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder sendMessage(InputBotInlineMessage sendMessage) {
            this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInputBotInlineResultPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputBotInlineResultPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("photo");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sendMessage");
            }
            return "Cannot build InputBotInlineResultPhoto, some of required attributes are not set " + attributes;
        }
    }
}

