/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputChannelEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputChannelEmpty
implements InputChannelEmpty {
    private final int identifier;
    private static final ImmutableInputChannelEmpty INSTANCE = ImmutableInputChannelEmpty.validate(new ImmutableInputChannelEmpty());

    private ImmutableInputChannelEmpty() {
        this.identifier = InputChannelEmpty.super.identifier();
    }

    private ImmutableInputChannelEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputChannelEmpty.super.identifier();
    }

    private ImmutableInputChannelEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputChannelEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputChannelEmpty.validate(new ImmutableInputChannelEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputChannelEmpty && this.equalTo(0, (ImmutableInputChannelEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputChannelEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputChannelEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputChannelEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputChannelEmpty validate(ImmutableInputChannelEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputChannelEmpty copyOf(InputChannelEmpty instance) {
        if (instance instanceof ImmutableInputChannelEmpty) {
            return (ImmutableInputChannelEmpty)instance;
        }
        return ImmutableInputChannelEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputChannelEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputChannel) {
                instance = (InputChannel)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputChannelEmpty) {
                instance = (InputChannelEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputChannelEmpty build() {
            return ImmutableInputChannelEmpty.validate(new ImmutableInputChannelEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

