/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputChannelFromMessage;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputChannelFromMessage
implements InputChannelFromMessage {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;
    private final long channelId;

    private ImmutableInputChannelFromMessage(InputPeer peer, int msgId, long channelId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.channelId = channelId;
        this.identifier = InputChannelFromMessage.super.identifier();
    }

    private ImmutableInputChannelFromMessage(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.channelId = builder.channelId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputChannelFromMessage.super.identifier();
    }

    private ImmutableInputChannelFromMessage(int identifier, InputPeer peer, int msgId, long channelId) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
        this.channelId = channelId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    public final ImmutableInputChannelFromMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputChannelFromMessage(value, this.peer, this.msgId, this.channelId);
    }

    public final ImmutableInputChannelFromMessage withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInputChannelFromMessage(this.identifier, newValue, this.msgId, this.channelId);
    }

    public final ImmutableInputChannelFromMessage withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableInputChannelFromMessage(this.identifier, this.peer, value, this.channelId);
    }

    public final ImmutableInputChannelFromMessage withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableInputChannelFromMessage(this.identifier, this.peer, this.msgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputChannelFromMessage && this.equalTo(0, (ImmutableInputChannelFromMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputChannelFromMessage another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId && this.channelId == another.channelId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + Long.hashCode(this.channelId);
        return h;
    }

    public String toString() {
        return "InputChannelFromMessage{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + ", channelId=" + this.channelId + "}";
    }

    public static ImmutableInputChannelFromMessage of(InputPeer peer, int msgId, long channelId) {
        return new ImmutableInputChannelFromMessage(peer, msgId, channelId);
    }

    public static ImmutableInputChannelFromMessage copyOf(InputChannelFromMessage instance) {
        if (instance instanceof ImmutableInputChannelFromMessage) {
            return (ImmutableInputChannelFromMessage)instance;
        }
        return ImmutableInputChannelFromMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int msgId;
        private long channelId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputChannelFromMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputChannel) {
                instance = (InputChannel)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputChannelFromMessage) {
                instance = (InputChannelFromMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.peer(instance.peer());
                this.channelId(instance.channelId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputChannelFromMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputChannelFromMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("channelId");
            }
            return "Cannot build InputChannelFromMessage, some of required attributes are not set " + attributes;
        }
    }
}

