/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputChatPhoto;
import telegram4j.tl.InputChatUploadedPhoto;
import telegram4j.tl.InputFile;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputChatUploadedPhoto
implements InputChatUploadedPhoto {
    private final int identifier;
    private final int flags;
    @Nullable
    private final InputFile file;
    @Nullable
    private final InputFile video;
    @Nullable
    private final Double videoStartTs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInputChatUploadedPhoto INSTANCE = ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto());

    private ImmutableInputChatUploadedPhoto() {
        this.file = null;
        this.video = null;
        this.videoStartTs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputChatUploadedPhoto(Builder builder) {
        this.file = builder.file;
        this.video = builder.video;
        this.videoStartTs = builder.videoStartTs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputChatUploadedPhoto(int identifier, int flags, @Nullable InputFile file, @Nullable InputFile video, @Nullable Double videoStartTs) {
        this.identifier = identifier;
        this.flags = flags;
        this.file = file;
        this.video = video;
        this.videoStartTs = videoStartTs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputChatUploadedPhoto.super.identifier();
    }

    private int flagsInitialize() {
        return InputChatUploadedPhoto.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public InputFile file() {
        return this.file;
    }

    @Override
    @Nullable
    public InputFile video() {
        return this.video;
    }

    @Override
    @Nullable
    public Double videoStartTs() {
        return this.videoStartTs;
    }

    public final ImmutableInputChatUploadedPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto(value, this.flags, this.file, this.video, this.videoStartTs));
    }

    public final ImmutableInputChatUploadedPhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto(this.identifier, value, this.file, this.video, this.videoStartTs));
    }

    public final ImmutableInputChatUploadedPhoto withFile(@Nullable InputFile value) {
        if (this.file == value) {
            return this;
        }
        return ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto(this.identifier, this.flags, value, this.video, this.videoStartTs));
    }

    public final ImmutableInputChatUploadedPhoto withVideo(@Nullable InputFile value) {
        if (this.video == value) {
            return this;
        }
        return ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto(this.identifier, this.flags, this.file, value, this.videoStartTs));
    }

    public final ImmutableInputChatUploadedPhoto withVideoStartTs(@Nullable Double value) {
        if (Objects.equals(this.videoStartTs, value)) {
            return this;
        }
        return ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto(this.identifier, this.flags, this.file, this.video, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputChatUploadedPhoto && this.equalTo(0, (ImmutableInputChatUploadedPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputChatUploadedPhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.file, another.file) && Objects.equals(this.video, another.video) && Objects.equals(this.videoStartTs, another.videoStartTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.file);
        h += (h << 5) + Objects.hashCode(this.video);
        h += (h << 5) + Objects.hashCode(this.videoStartTs);
        return h;
    }

    public String toString() {
        return "InputChatUploadedPhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", file=" + this.file + ", video=" + this.video + ", videoStartTs=" + this.videoStartTs + "}";
    }

    public static ImmutableInputChatUploadedPhoto of() {
        return INSTANCE;
    }

    private static ImmutableInputChatUploadedPhoto validate(ImmutableInputChatUploadedPhoto instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputChatUploadedPhoto copyOf(InputChatUploadedPhoto instance) {
        if (instance instanceof ImmutableInputChatUploadedPhoto) {
            return (ImmutableInputChatUploadedPhoto)instance;
        }
        return ImmutableInputChatUploadedPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputFile file;
        private InputFile video;
        private Double videoStartTs;

        private Builder() {
        }

        public final Builder from(InputChatUploadedPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputChatPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputChatPhoto instance;
            long bits = 0L;
            if (object instanceof InputChatUploadedPhoto) {
                InputFile videoValue;
                Double videoStartTsValue;
                InputFile fileValue;
                instance = (InputChatUploadedPhoto)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((fileValue = instance.file()) != null) {
                    this.file(fileValue);
                }
                if ((videoStartTsValue = instance.videoStartTs()) != null) {
                    this.videoStartTs(videoStartTsValue);
                }
                if ((videoValue = instance.video()) != null) {
                    this.video(videoValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputChatPhoto) {
                instance = (InputChatPhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder file(@Nullable InputFile file) {
            this.file = file;
            return this;
        }

        public final Builder video(@Nullable InputFile video) {
            this.video = video;
            return this;
        }

        public final Builder videoStartTs(@Nullable Double videoStartTs) {
            this.videoStartTs = videoStartTs;
            return this;
        }

        public ImmutableInputChatUploadedPhoto build() {
            return ImmutableInputChatUploadedPhoto.validate(new ImmutableInputChatUploadedPhoto(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputChatUploadedPhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputChatUploadedPhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputChatUploadedPhoto, attribute initializers form cycle " + attributes;
        }
    }
}

