/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputClientProxy;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputClientProxy
implements InputClientProxy {
    private final int identifier;
    private final String address;
    private final int port;

    private ImmutableInputClientProxy(String address, int port) {
        this.address = Objects.requireNonNull(address, "address");
        this.port = port;
        this.identifier = InputClientProxy.super.identifier();
    }

    private ImmutableInputClientProxy(Builder builder) {
        this.address = builder.address;
        this.port = builder.port;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputClientProxy.super.identifier();
    }

    private ImmutableInputClientProxy(int identifier, String address, int port) {
        this.identifier = identifier;
        this.address = address;
        this.port = port;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public int port() {
        return this.port;
    }

    public final ImmutableInputClientProxy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputClientProxy(value, this.address, this.port);
    }

    public final ImmutableInputClientProxy withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableInputClientProxy(this.identifier, newValue, this.port);
    }

    public final ImmutableInputClientProxy withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableInputClientProxy(this.identifier, this.address, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputClientProxy && this.equalTo(0, (ImmutableInputClientProxy)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputClientProxy another) {
        return this.identifier == another.identifier && this.address.equals(another.address) && this.port == another.port;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + this.port;
        return h;
    }

    public String toString() {
        return "InputClientProxy{identifier=" + this.identifier + ", address=" + this.address + ", port=" + this.port + "}";
    }

    public static ImmutableInputClientProxy of(String address, int port) {
        return new ImmutableInputClientProxy(address, port);
    }

    public static ImmutableInputClientProxy copyOf(InputClientProxy instance) {
        if (instance instanceof ImmutableInputClientProxy) {
            return (ImmutableInputClientProxy)instance;
        }
        return ImmutableInputClientProxy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ADDRESS = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String address;
        private int port;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputClientProxy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputClientProxy) {
                instance = (InputClientProxy)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.port(instance.port());
                this.address(instance.address());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputClientProxy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputClientProxy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build InputClientProxy, some of required attributes are not set " + attributes;
        }
    }
}

