/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputContact;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputContact
implements InputContact {
    private final int identifier;
    private final long clientId;
    private final String phone;
    private final String firstName;
    private final String lastName;

    private ImmutableInputContact(long clientId, String phone, String firstName, String lastName) {
        this.clientId = clientId;
        this.phone = Objects.requireNonNull(phone, "phone");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.identifier = InputContact.super.identifier();
    }

    private ImmutableInputContact(Builder builder) {
        this.clientId = builder.clientId;
        this.phone = builder.phone;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputContact.super.identifier();
    }

    private ImmutableInputContact(int identifier, long clientId, String phone, String firstName, String lastName) {
        this.identifier = identifier;
        this.clientId = clientId;
        this.phone = phone;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long clientId() {
        return this.clientId;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    public final ImmutableInputContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputContact(value, this.clientId, this.phone, this.firstName, this.lastName);
    }

    public final ImmutableInputContact withClientId(long value) {
        if (this.clientId == value) {
            return this;
        }
        return new ImmutableInputContact(this.identifier, value, this.phone, this.firstName, this.lastName);
    }

    public final ImmutableInputContact withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableInputContact(this.identifier, this.clientId, newValue, this.firstName, this.lastName);
    }

    public final ImmutableInputContact withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputContact(this.identifier, this.clientId, this.phone, newValue, this.lastName);
    }

    public final ImmutableInputContact withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputContact(this.identifier, this.clientId, this.phone, this.firstName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputContact && this.equalTo(0, (ImmutableInputContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputContact another) {
        return this.identifier == another.identifier && this.clientId == another.clientId && this.phone.equals(another.phone) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.clientId);
        h += (h << 5) + this.phone.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        return h;
    }

    public String toString() {
        return "InputContact{identifier=" + this.identifier + ", clientId=" + this.clientId + ", phone=" + this.phone + ", firstName=" + this.firstName + ", lastName=" + this.lastName + "}";
    }

    public static ImmutableInputContact of(long clientId, String phone, String firstName, String lastName) {
        return new ImmutableInputContact(clientId, phone, firstName, lastName);
    }

    public static ImmutableInputContact copyOf(InputContact instance) {
        if (instance instanceof ImmutableInputContact) {
            return (ImmutableInputContact)instance;
        }
        return ImmutableInputContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_PHONE = 2L;
        private static final long INIT_BIT_FIRST_NAME = 4L;
        private static final long INIT_BIT_LAST_NAME = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long clientId;
        private String phone;
        private String firstName;
        private String lastName;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputContact) {
                instance = (InputContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.clientId(instance.clientId());
                this.phone(instance.phone());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder clientId(long clientId) {
            this.clientId = clientId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInputContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phone");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lastName");
            }
            return "Cannot build InputContact, some of required attributes are not set " + attributes;
        }
    }
}

