/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDialogPeer;
import telegram4j.tl.InputDialogPeerFolder;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputDialogPeerFolder
implements InputDialogPeerFolder {
    private final int identifier;
    private final int folderId;

    private ImmutableInputDialogPeerFolder(int folderId) {
        this.folderId = folderId;
        this.identifier = InputDialogPeerFolder.super.identifier();
    }

    private ImmutableInputDialogPeerFolder(Builder builder) {
        this.folderId = builder.folderId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputDialogPeerFolder.super.identifier();
    }

    private ImmutableInputDialogPeerFolder(int identifier, int folderId) {
        this.identifier = identifier;
        this.folderId = folderId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int folderId() {
        return this.folderId;
    }

    public final ImmutableInputDialogPeerFolder withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputDialogPeerFolder(value, this.folderId);
    }

    public final ImmutableInputDialogPeerFolder withFolderId(int value) {
        if (this.folderId == value) {
            return this;
        }
        return new ImmutableInputDialogPeerFolder(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputDialogPeerFolder && this.equalTo(0, (ImmutableInputDialogPeerFolder)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputDialogPeerFolder another) {
        return this.identifier == another.identifier && this.folderId == another.folderId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.folderId;
        return h;
    }

    public String toString() {
        return "InputDialogPeerFolder{identifier=" + this.identifier + ", folderId=" + this.folderId + "}";
    }

    public static ImmutableInputDialogPeerFolder of(int folderId) {
        return new ImmutableInputDialogPeerFolder(folderId);
    }

    public static ImmutableInputDialogPeerFolder copyOf(InputDialogPeerFolder instance) {
        if (instance instanceof ImmutableInputDialogPeerFolder) {
            return (ImmutableInputDialogPeerFolder)instance;
        }
        return ImmutableInputDialogPeerFolder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FOLDER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int folderId;

        private Builder() {
        }

        public final Builder from(InputDialogPeerFolder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputDialogPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputDialogPeer instance;
            long bits = 0L;
            if (object instanceof InputDialogPeerFolder) {
                instance = (InputDialogPeerFolder)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.folderId(instance.folderId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputDialogPeer) {
                instance = (InputDialogPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder folderId(int folderId) {
            this.folderId = folderId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputDialogPeerFolder build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputDialogPeerFolder(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("folderId");
            }
            return "Cannot build InputDialogPeerFolder, some of required attributes are not set " + attributes;
        }
    }
}

