/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputDocumentEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputDocumentEmpty
implements InputDocumentEmpty {
    private final int identifier;
    private static final ImmutableInputDocumentEmpty INSTANCE = ImmutableInputDocumentEmpty.validate(new ImmutableInputDocumentEmpty());

    private ImmutableInputDocumentEmpty() {
        this.identifier = InputDocumentEmpty.super.identifier();
    }

    private ImmutableInputDocumentEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputDocumentEmpty.super.identifier();
    }

    private ImmutableInputDocumentEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputDocumentEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputDocumentEmpty.validate(new ImmutableInputDocumentEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputDocumentEmpty && this.equalTo(0, (ImmutableInputDocumentEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputDocumentEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputDocumentEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputDocumentEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputDocumentEmpty validate(ImmutableInputDocumentEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputDocumentEmpty copyOf(InputDocumentEmpty instance) {
        if (instance instanceof ImmutableInputDocumentEmpty) {
            return (ImmutableInputDocumentEmpty)instance;
        }
        return ImmutableInputDocumentEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputDocumentEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputDocument instance;
            long bits = 0L;
            if (object instanceof InputDocumentEmpty) {
                instance = (InputDocumentEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputDocument) {
                instance = (InputDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputDocumentEmpty build() {
            return ImmutableInputDocumentEmpty.validate(new ImmutableInputDocumentEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

