/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocumentFileLocation;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputDocumentFileLocation
implements InputDocumentFileLocation {
    private final int identifier;
    private final long id;
    private final long accessHash;
    private final ByteBuf fileReference;
    private final String thumbSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputDocumentFileLocation(long id, long accessHash, String thumbSize) {
        this.id = id;
        this.accessHash = accessHash;
        this.thumbSize = Objects.requireNonNull(thumbSize, "thumbSize");
        this.fileReference = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputDocumentFileLocation(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.fileReference = builder.fileReference_build();
        this.thumbSize = builder.thumbSize;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputDocumentFileLocation(int identifier, long id, long accessHash, ByteBuf fileReference, String thumbSize) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.fileReference = fileReference;
        this.thumbSize = thumbSize;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputDocumentFileLocation.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public ByteBuf fileReference() {
        return this.fileReference.duplicate();
    }

    @Override
    public String thumbSize() {
        return this.thumbSize;
    }

    public final ImmutableInputDocumentFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputDocumentFileLocation(value, this.id, this.accessHash, this.fileReference, this.thumbSize);
    }

    public final ImmutableInputDocumentFileLocation withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputDocumentFileLocation(this.identifier, value, this.accessHash, this.fileReference, this.thumbSize);
    }

    public final ImmutableInputDocumentFileLocation withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputDocumentFileLocation(this.identifier, this.id, value, this.fileReference, this.thumbSize);
    }

    public ImmutableInputDocumentFileLocation withFileReference(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileReference == newValue) {
            return this;
        }
        return new ImmutableInputDocumentFileLocation(this.identifier, this.id, this.accessHash, newValue, this.thumbSize);
    }

    public final ImmutableInputDocumentFileLocation withThumbSize(String value) {
        String newValue = Objects.requireNonNull(value, "thumbSize");
        if (this.thumbSize.equals(newValue)) {
            return this;
        }
        return new ImmutableInputDocumentFileLocation(this.identifier, this.id, this.accessHash, this.fileReference, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputDocumentFileLocation && this.equalTo(0, (ImmutableInputDocumentFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputDocumentFileLocation another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.fileReference().equals((Object)another.fileReference()) && this.thumbSize.equals(another.thumbSize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.fileReference().hashCode();
        h += (h << 5) + this.thumbSize.hashCode();
        return h;
    }

    public String toString() {
        return "InputDocumentFileLocation{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", fileReference=" + ByteBufUtil.hexDump((ByteBuf)this.fileReference) + ", thumbSize=" + this.thumbSize + "}";
    }

    public static ImmutableInputDocumentFileLocation of(long id, long accessHash, String thumbSize) {
        return new ImmutableInputDocumentFileLocation(id, accessHash, thumbSize);
    }

    public static ImmutableInputDocumentFileLocation copyOf(InputDocumentFileLocation instance) {
        if (instance instanceof ImmutableInputDocumentFileLocation) {
            return (ImmutableInputDocumentFileLocation)instance;
        }
        return ImmutableInputDocumentFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_THUMB_SIZE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf fileReference_value = null;
        private int identifier;
        private long id;
        private long accessHash;
        private String thumbSize;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputDocumentFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputDocumentFileLocation) {
                instance = (InputDocumentFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                this.fileReference(instance.fileReference());
                this.thumbSize(instance.thumbSize());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder fileReference(ByteBuf value) {
            this.fileReference_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder thumbSize(String thumbSize) {
            this.thumbSize = Objects.requireNonNull(thumbSize, "thumbSize");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputDocumentFileLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputDocumentFileLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("thumbSize");
            }
            return "Cannot build InputDocumentFileLocation, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileReference_build() {
            return Objects.requireNonNull(this.fileReference_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputDocumentFileLocation.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build InputDocumentFileLocation, attribute initializers form cycle " + attributes;
        }
    }
}

