/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputEncryptedChat
implements InputEncryptedChat {
    private final int identifier;
    private final int chatId;
    private final long accessHash;

    private ImmutableInputEncryptedChat(int chatId, long accessHash) {
        this.chatId = chatId;
        this.accessHash = accessHash;
        this.identifier = InputEncryptedChat.super.identifier();
    }

    private ImmutableInputEncryptedChat(Builder builder) {
        this.chatId = builder.chatId;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputEncryptedChat.super.identifier();
    }

    private ImmutableInputEncryptedChat(int identifier, int chatId, long accessHash) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int chatId() {
        return this.chatId;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableInputEncryptedChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputEncryptedChat(value, this.chatId, this.accessHash);
    }

    public final ImmutableInputEncryptedChat withChatId(int value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableInputEncryptedChat(this.identifier, value, this.accessHash);
    }

    public final ImmutableInputEncryptedChat withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputEncryptedChat(this.identifier, this.chatId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputEncryptedChat && this.equalTo(0, (ImmutableInputEncryptedChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputEncryptedChat another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chatId;
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "InputEncryptedChat{identifier=" + this.identifier + ", chatId=" + this.chatId + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableInputEncryptedChat of(int chatId, long accessHash) {
        return new ImmutableInputEncryptedChat(chatId, accessHash);
    }

    public static ImmutableInputEncryptedChat copyOf(InputEncryptedChat instance) {
        if (instance instanceof ImmutableInputEncryptedChat) {
            return (ImmutableInputEncryptedChat)instance;
        }
        return ImmutableInputEncryptedChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int chatId;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(InputEncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputEncryptedChat instance;
            long bits = 0L;
            if (object instanceof InputEncryptedChat) {
                instance = (InputEncryptedChat)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(int chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputEncryptedChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputEncryptedChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build InputEncryptedChat, some of required attributes are not set " + attributes;
        }
    }
}

