/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedFile;
import telegram4j.tl.InputEncryptedFileBigUploaded;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputEncryptedFileBigUploaded
implements InputEncryptedFileBigUploaded {
    private final int identifier;
    private final long id;
    private final int parts;
    private final int keyFingerprint;

    private ImmutableInputEncryptedFileBigUploaded(long id, int parts, int keyFingerprint) {
        this.id = id;
        this.parts = parts;
        this.keyFingerprint = keyFingerprint;
        this.identifier = InputEncryptedFileBigUploaded.super.identifier();
    }

    private ImmutableInputEncryptedFileBigUploaded(Builder builder) {
        this.id = builder.id;
        this.parts = builder.parts;
        this.keyFingerprint = builder.keyFingerprint;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputEncryptedFileBigUploaded.super.identifier();
    }

    private ImmutableInputEncryptedFileBigUploaded(int identifier, long id, int parts, int keyFingerprint) {
        this.identifier = identifier;
        this.id = id;
        this.parts = parts;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int parts() {
        return this.parts;
    }

    @Override
    public int keyFingerprint() {
        return this.keyFingerprint;
    }

    public final ImmutableInputEncryptedFileBigUploaded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileBigUploaded(value, this.id, this.parts, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileBigUploaded withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileBigUploaded(this.identifier, value, this.parts, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileBigUploaded withParts(int value) {
        if (this.parts == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileBigUploaded(this.identifier, this.id, value, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileBigUploaded withKeyFingerprint(int value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileBigUploaded(this.identifier, this.id, this.parts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputEncryptedFileBigUploaded && this.equalTo(0, (ImmutableInputEncryptedFileBigUploaded)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputEncryptedFileBigUploaded another) {
        return this.identifier == another.identifier && this.id == another.id && this.parts == another.parts && this.keyFingerprint == another.keyFingerprint;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.parts;
        h += (h << 5) + this.keyFingerprint;
        return h;
    }

    public String toString() {
        return "InputEncryptedFileBigUploaded{identifier=" + this.identifier + ", id=" + this.id + ", parts=" + this.parts + ", keyFingerprint=" + this.keyFingerprint + "}";
    }

    public static ImmutableInputEncryptedFileBigUploaded of(long id, int parts, int keyFingerprint) {
        return new ImmutableInputEncryptedFileBigUploaded(id, parts, keyFingerprint);
    }

    public static ImmutableInputEncryptedFileBigUploaded copyOf(InputEncryptedFileBigUploaded instance) {
        if (instance instanceof ImmutableInputEncryptedFileBigUploaded) {
            return (ImmutableInputEncryptedFileBigUploaded)instance;
        }
        return ImmutableInputEncryptedFileBigUploaded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PARTS = 2L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long id;
        private int parts;
        private int keyFingerprint;

        private Builder() {
        }

        public final Builder from(InputEncryptedFileBigUploaded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputEncryptedFile instance;
            long bits = 0L;
            if (object instanceof InputEncryptedFileBigUploaded) {
                instance = (InputEncryptedFileBigUploaded)object;
                this.parts(instance.parts());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.keyFingerprint(instance.keyFingerprint());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputEncryptedFile) {
                instance = (InputEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parts(int parts) {
            this.parts = parts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder keyFingerprint(int keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputEncryptedFileBigUploaded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputEncryptedFileBigUploaded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("keyFingerprint");
            }
            return "Cannot build InputEncryptedFileBigUploaded, some of required attributes are not set " + attributes;
        }
    }
}

