/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputEncryptedFile;
import telegram4j.tl.InputEncryptedFileEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputEncryptedFileEmpty
implements InputEncryptedFileEmpty {
    private final int identifier;
    private static final ImmutableInputEncryptedFileEmpty INSTANCE = ImmutableInputEncryptedFileEmpty.validate(new ImmutableInputEncryptedFileEmpty());

    private ImmutableInputEncryptedFileEmpty() {
        this.identifier = InputEncryptedFileEmpty.super.identifier();
    }

    private ImmutableInputEncryptedFileEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputEncryptedFileEmpty.super.identifier();
    }

    private ImmutableInputEncryptedFileEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputEncryptedFileEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputEncryptedFileEmpty.validate(new ImmutableInputEncryptedFileEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputEncryptedFileEmpty && this.equalTo(0, (ImmutableInputEncryptedFileEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputEncryptedFileEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputEncryptedFileEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputEncryptedFileEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputEncryptedFileEmpty validate(ImmutableInputEncryptedFileEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputEncryptedFileEmpty copyOf(InputEncryptedFileEmpty instance) {
        if (instance instanceof ImmutableInputEncryptedFileEmpty) {
            return (ImmutableInputEncryptedFileEmpty)instance;
        }
        return ImmutableInputEncryptedFileEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputEncryptedFileEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputEncryptedFile instance;
            long bits = 0L;
            if (object instanceof InputEncryptedFileEmpty) {
                instance = (InputEncryptedFileEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputEncryptedFile) {
                instance = (InputEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputEncryptedFileEmpty build() {
            return ImmutableInputEncryptedFileEmpty.validate(new ImmutableInputEncryptedFileEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

