/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedFileLocation;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputEncryptedFileLocation
implements InputEncryptedFileLocation {
    private final int identifier;
    private final long id;
    private final long accessHash;

    private ImmutableInputEncryptedFileLocation(long id, long accessHash) {
        this.id = id;
        this.accessHash = accessHash;
        this.identifier = InputEncryptedFileLocation.super.identifier();
    }

    private ImmutableInputEncryptedFileLocation(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputEncryptedFileLocation.super.identifier();
    }

    private ImmutableInputEncryptedFileLocation(int identifier, long id, long accessHash) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableInputEncryptedFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileLocation(value, this.id, this.accessHash);
    }

    public final ImmutableInputEncryptedFileLocation withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileLocation(this.identifier, value, this.accessHash);
    }

    public final ImmutableInputEncryptedFileLocation withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileLocation(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputEncryptedFileLocation && this.equalTo(0, (ImmutableInputEncryptedFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputEncryptedFileLocation another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "InputEncryptedFileLocation{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableInputEncryptedFileLocation of(long id, long accessHash) {
        return new ImmutableInputEncryptedFileLocation(id, accessHash);
    }

    public static ImmutableInputEncryptedFileLocation copyOf(InputEncryptedFileLocation instance) {
        if (instance instanceof ImmutableInputEncryptedFileLocation) {
            return (ImmutableInputEncryptedFileLocation)instance;
        }
        return ImmutableInputEncryptedFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long id;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputEncryptedFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputEncryptedFileLocation) {
                instance = (InputEncryptedFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputEncryptedFileLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputEncryptedFileLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build InputEncryptedFileLocation, some of required attributes are not set " + attributes;
        }
    }
}

