/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedFile;
import telegram4j.tl.InputEncryptedFileUploaded;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputEncryptedFileUploaded
implements InputEncryptedFileUploaded {
    private final int identifier;
    private final long id;
    private final int parts;
    private final String md5Checksum;
    private final int keyFingerprint;

    private ImmutableInputEncryptedFileUploaded(long id, int parts, String md5Checksum, int keyFingerprint) {
        this.id = id;
        this.parts = parts;
        this.md5Checksum = Objects.requireNonNull(md5Checksum, "md5Checksum");
        this.keyFingerprint = keyFingerprint;
        this.identifier = InputEncryptedFileUploaded.super.identifier();
    }

    private ImmutableInputEncryptedFileUploaded(Builder builder) {
        this.id = builder.id;
        this.parts = builder.parts;
        this.md5Checksum = builder.md5Checksum;
        this.keyFingerprint = builder.keyFingerprint;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputEncryptedFileUploaded.super.identifier();
    }

    private ImmutableInputEncryptedFileUploaded(int identifier, long id, int parts, String md5Checksum, int keyFingerprint) {
        this.identifier = identifier;
        this.id = id;
        this.parts = parts;
        this.md5Checksum = md5Checksum;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int parts() {
        return this.parts;
    }

    @Override
    public String md5Checksum() {
        return this.md5Checksum;
    }

    @Override
    public int keyFingerprint() {
        return this.keyFingerprint;
    }

    public final ImmutableInputEncryptedFileUploaded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileUploaded(value, this.id, this.parts, this.md5Checksum, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileUploaded withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileUploaded(this.identifier, value, this.parts, this.md5Checksum, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileUploaded withParts(int value) {
        if (this.parts == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileUploaded(this.identifier, this.id, value, this.md5Checksum, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileUploaded withMd5Checksum(String value) {
        String newValue = Objects.requireNonNull(value, "md5Checksum");
        if (this.md5Checksum.equals(newValue)) {
            return this;
        }
        return new ImmutableInputEncryptedFileUploaded(this.identifier, this.id, this.parts, newValue, this.keyFingerprint);
    }

    public final ImmutableInputEncryptedFileUploaded withKeyFingerprint(int value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableInputEncryptedFileUploaded(this.identifier, this.id, this.parts, this.md5Checksum, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputEncryptedFileUploaded && this.equalTo(0, (ImmutableInputEncryptedFileUploaded)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputEncryptedFileUploaded another) {
        return this.identifier == another.identifier && this.id == another.id && this.parts == another.parts && this.md5Checksum.equals(another.md5Checksum) && this.keyFingerprint == another.keyFingerprint;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.parts;
        h += (h << 5) + this.md5Checksum.hashCode();
        h += (h << 5) + this.keyFingerprint;
        return h;
    }

    public String toString() {
        return "InputEncryptedFileUploaded{identifier=" + this.identifier + ", id=" + this.id + ", parts=" + this.parts + ", md5Checksum=" + this.md5Checksum + ", keyFingerprint=" + this.keyFingerprint + "}";
    }

    public static ImmutableInputEncryptedFileUploaded of(long id, int parts, String md5Checksum, int keyFingerprint) {
        return new ImmutableInputEncryptedFileUploaded(id, parts, md5Checksum, keyFingerprint);
    }

    public static ImmutableInputEncryptedFileUploaded copyOf(InputEncryptedFileUploaded instance) {
        if (instance instanceof ImmutableInputEncryptedFileUploaded) {
            return (ImmutableInputEncryptedFileUploaded)instance;
        }
        return ImmutableInputEncryptedFileUploaded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PARTS = 2L;
        private static final long INIT_BIT_MD5_CHECKSUM = 4L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long id;
        private int parts;
        private String md5Checksum;
        private int keyFingerprint;

        private Builder() {
        }

        public final Builder from(InputEncryptedFileUploaded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputEncryptedFile instance;
            long bits = 0L;
            if (object instanceof InputEncryptedFileUploaded) {
                instance = (InputEncryptedFileUploaded)object;
                this.md5Checksum(instance.md5Checksum());
                this.parts(instance.parts());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.keyFingerprint(instance.keyFingerprint());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputEncryptedFile) {
                instance = (InputEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parts(int parts) {
            this.parts = parts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder md5Checksum(String md5Checksum) {
            this.md5Checksum = Objects.requireNonNull(md5Checksum, "md5Checksum");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder keyFingerprint(int keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInputEncryptedFileUploaded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputEncryptedFileUploaded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("md5Checksum");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("keyFingerprint");
            }
            return "Cannot build InputEncryptedFileUploaded, some of required attributes are not set " + attributes;
        }
    }
}

