/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFile;
import telegram4j.tl.InputFileBig;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputFileBig
implements InputFileBig {
    private final int identifier;
    private final long id;
    private final int parts;
    private final String name;

    private ImmutableInputFileBig(long id, int parts, String name) {
        this.id = id;
        this.parts = parts;
        this.name = Objects.requireNonNull(name, "name");
        this.identifier = InputFileBig.super.identifier();
    }

    private ImmutableInputFileBig(Builder builder) {
        this.id = builder.id;
        this.parts = builder.parts;
        this.name = builder.name;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputFileBig.super.identifier();
    }

    private ImmutableInputFileBig(int identifier, long id, int parts, String name) {
        this.identifier = identifier;
        this.id = id;
        this.parts = parts;
        this.name = name;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int parts() {
        return this.parts;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutableInputFileBig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputFileBig(value, this.id, this.parts, this.name);
    }

    public final ImmutableInputFileBig withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputFileBig(this.identifier, value, this.parts, this.name);
    }

    public final ImmutableInputFileBig withParts(int value) {
        if (this.parts == value) {
            return this;
        }
        return new ImmutableInputFileBig(this.identifier, this.id, value, this.name);
    }

    public final ImmutableInputFileBig withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableInputFileBig(this.identifier, this.id, this.parts, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputFileBig && this.equalTo(0, (ImmutableInputFileBig)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputFileBig another) {
        return this.identifier == another.identifier && this.id == another.id && this.parts == another.parts && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.parts;
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "InputFileBig{identifier=" + this.identifier + ", id=" + this.id + ", parts=" + this.parts + ", name=" + this.name + "}";
    }

    public static ImmutableInputFileBig of(long id, int parts, String name) {
        return new ImmutableInputFileBig(id, parts, name);
    }

    public static ImmutableInputFileBig copyOf(InputFileBig instance) {
        if (instance instanceof ImmutableInputFileBig) {
            return (ImmutableInputFileBig)instance;
        }
        return ImmutableInputFileBig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PARTS = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long id;
        private int parts;
        private String name;

        private Builder() {
        }

        public final Builder from(InputFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputFileBig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFile instance;
            long bits = 0L;
            if (object instanceof InputFile) {
                instance = (InputFile)object;
                if ((bits & 2L) == 0L) {
                    this.parts(instance.parts());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.name(instance.name());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.id(instance.id());
                    bits |= 8L;
                }
            }
            if (object instanceof InputFileBig) {
                instance = (InputFileBig)object;
                if ((bits & 2L) == 0L) {
                    this.parts(instance.parts());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.name(instance.name());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.id(instance.id());
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parts(int parts) {
            this.parts = parts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputFileBig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputFileBig(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build InputFileBig, some of required attributes are not set " + attributes;
        }
    }
}

