/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFolderPeer;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputFolderPeer
implements InputFolderPeer {
    private final int identifier;
    private final InputPeer peer;
    private final int folderId;

    private ImmutableInputFolderPeer(InputPeer peer, int folderId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.folderId = folderId;
        this.identifier = InputFolderPeer.super.identifier();
    }

    private ImmutableInputFolderPeer(Builder builder) {
        this.peer = builder.peer;
        this.folderId = builder.folderId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputFolderPeer.super.identifier();
    }

    private ImmutableInputFolderPeer(int identifier, InputPeer peer, int folderId) {
        this.identifier = identifier;
        this.peer = peer;
        this.folderId = folderId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int folderId() {
        return this.folderId;
    }

    public final ImmutableInputFolderPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputFolderPeer(value, this.peer, this.folderId);
    }

    public final ImmutableInputFolderPeer withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInputFolderPeer(this.identifier, newValue, this.folderId);
    }

    public final ImmutableInputFolderPeer withFolderId(int value) {
        if (this.folderId == value) {
            return this;
        }
        return new ImmutableInputFolderPeer(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputFolderPeer && this.equalTo(0, (ImmutableInputFolderPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputFolderPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.folderId == another.folderId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.folderId;
        return h;
    }

    public String toString() {
        return "InputFolderPeer{identifier=" + this.identifier + ", peer=" + this.peer + ", folderId=" + this.folderId + "}";
    }

    public static ImmutableInputFolderPeer of(InputPeer peer, int folderId) {
        return new ImmutableInputFolderPeer(peer, folderId);
    }

    public static ImmutableInputFolderPeer copyOf(InputFolderPeer instance) {
        if (instance instanceof ImmutableInputFolderPeer) {
            return (ImmutableInputFolderPeer)instance;
        }
        return ImmutableInputFolderPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FOLDER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int folderId;

        private Builder() {
        }

        public final Builder from(InputFolderPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFolderPeer instance;
            long bits = 0L;
            if (object instanceof InputFolderPeer) {
                instance = (InputFolderPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.folderId(instance.folderId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder folderId(int folderId) {
            this.folderId = folderId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputFolderPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputFolderPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("folderId");
            }
            return "Cannot build InputFolderPeer, some of required attributes are not set " + attributes;
        }
    }
}

