/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGame;
import telegram4j.tl.InputGameShortName;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputGameShortName
implements InputGameShortName {
    private final int identifier;
    private final InputUser botId;
    private final String shortName;

    private ImmutableInputGameShortName(InputUser botId, String shortName) {
        this.botId = Objects.requireNonNull(botId, "botId");
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.identifier = InputGameShortName.super.identifier();
    }

    private ImmutableInputGameShortName(Builder builder) {
        this.botId = builder.botId;
        this.shortName = builder.shortName;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputGameShortName.super.identifier();
    }

    private ImmutableInputGameShortName(int identifier, InputUser botId, String shortName) {
        this.identifier = identifier;
        this.botId = botId;
        this.shortName = shortName;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser botId() {
        return this.botId;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    public final ImmutableInputGameShortName withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputGameShortName(value, this.botId, this.shortName);
    }

    public final ImmutableInputGameShortName withBotId(InputUser value) {
        if (this.botId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "botId");
        return new ImmutableInputGameShortName(this.identifier, newValue, this.shortName);
    }

    public final ImmutableInputGameShortName withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputGameShortName(this.identifier, this.botId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputGameShortName && this.equalTo(0, (ImmutableInputGameShortName)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputGameShortName another) {
        return this.identifier == another.identifier && this.botId.equals(another.botId) && this.shortName.equals(another.shortName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.botId.hashCode();
        h += (h << 5) + this.shortName.hashCode();
        return h;
    }

    public String toString() {
        return "InputGameShortName{identifier=" + this.identifier + ", botId=" + this.botId + ", shortName=" + this.shortName + "}";
    }

    public static ImmutableInputGameShortName of(InputUser botId, String shortName) {
        return new ImmutableInputGameShortName(botId, shortName);
    }

    public static ImmutableInputGameShortName copyOf(InputGameShortName instance) {
        if (instance instanceof ImmutableInputGameShortName) {
            return (ImmutableInputGameShortName)instance;
        }
        return ImmutableInputGameShortName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT_ID = 1L;
        private static final long INIT_BIT_SHORT_NAME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputUser botId;
        private String shortName;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputGameShortName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputGame instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputGameShortName) {
                instance = (InputGameShortName)object;
                this.shortName(instance.shortName());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botId(instance.botId());
            }
            if (object instanceof InputGame) {
                instance = (InputGame)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder botId(InputUser botId) {
            this.botId = Objects.requireNonNull(botId, "botId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputGameShortName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputGameShortName(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("shortName");
            }
            return "Cannot build InputGameShortName, some of required attributes are not set " + attributes;
        }
    }
}

