/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.InputGroupCallStream;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputGroupCallStream
implements InputGroupCallStream {
    private final int identifier;
    private final int flags;
    private final InputGroupCall call;
    private final long timeMs;
    private final int scale;
    @Nullable
    private final Integer videoChannel;
    @Nullable
    private final Integer videoQuality;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputGroupCallStream(InputGroupCall call, long timeMs, int scale) {
        this.call = Objects.requireNonNull(call, "call");
        this.timeMs = timeMs;
        this.scale = scale;
        this.videoChannel = null;
        this.videoQuality = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputGroupCallStream(Builder builder) {
        this.call = builder.call;
        this.timeMs = builder.timeMs;
        this.scale = builder.scale;
        this.videoChannel = builder.videoChannel;
        this.videoQuality = builder.videoQuality;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputGroupCallStream(int identifier, int flags, InputGroupCall call, long timeMs, int scale, @Nullable Integer videoChannel, @Nullable Integer videoQuality) {
        this.identifier = identifier;
        this.flags = flags;
        this.call = call;
        this.timeMs = timeMs;
        this.scale = scale;
        this.videoChannel = videoChannel;
        this.videoQuality = videoQuality;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputGroupCallStream.super.identifier();
    }

    private int flagsInitialize() {
        return InputGroupCallStream.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public long timeMs() {
        return this.timeMs;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    @Nullable
    public Integer videoChannel() {
        return this.videoChannel;
    }

    @Override
    @Nullable
    public Integer videoQuality() {
        return this.videoQuality;
    }

    public final ImmutableInputGroupCallStream withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputGroupCallStream(value, this.flags, this.call, this.timeMs, this.scale, this.videoChannel, this.videoQuality);
    }

    public final ImmutableInputGroupCallStream withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputGroupCallStream(this.identifier, value, this.call, this.timeMs, this.scale, this.videoChannel, this.videoQuality);
    }

    public final ImmutableInputGroupCallStream withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableInputGroupCallStream(this.identifier, this.flags, newValue, this.timeMs, this.scale, this.videoChannel, this.videoQuality);
    }

    public final ImmutableInputGroupCallStream withTimeMs(long value) {
        if (this.timeMs == value) {
            return this;
        }
        return new ImmutableInputGroupCallStream(this.identifier, this.flags, this.call, value, this.scale, this.videoChannel, this.videoQuality);
    }

    public final ImmutableInputGroupCallStream withScale(int value) {
        if (this.scale == value) {
            return this;
        }
        return new ImmutableInputGroupCallStream(this.identifier, this.flags, this.call, this.timeMs, value, this.videoChannel, this.videoQuality);
    }

    public final ImmutableInputGroupCallStream withVideoChannel(@Nullable Integer value) {
        if (Objects.equals(this.videoChannel, value)) {
            return this;
        }
        return new ImmutableInputGroupCallStream(this.identifier, this.flags, this.call, this.timeMs, this.scale, value, this.videoQuality);
    }

    public final ImmutableInputGroupCallStream withVideoQuality(@Nullable Integer value) {
        if (Objects.equals(this.videoQuality, value)) {
            return this;
        }
        return new ImmutableInputGroupCallStream(this.identifier, this.flags, this.call, this.timeMs, this.scale, this.videoChannel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputGroupCallStream && this.equalTo(0, (ImmutableInputGroupCallStream)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputGroupCallStream another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.call.equals(another.call) && this.timeMs == another.timeMs && this.scale == another.scale && Objects.equals(this.videoChannel, another.videoChannel) && Objects.equals(this.videoQuality, another.videoQuality);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + Long.hashCode(this.timeMs);
        h += (h << 5) + this.scale;
        h += (h << 5) + Objects.hashCode(this.videoChannel);
        h += (h << 5) + Objects.hashCode(this.videoQuality);
        return h;
    }

    public String toString() {
        return "InputGroupCallStream{identifier=" + this.identifier + ", flags=" + this.flags + ", call=" + this.call + ", timeMs=" + this.timeMs + ", scale=" + this.scale + ", videoChannel=" + this.videoChannel + ", videoQuality=" + this.videoQuality + "}";
    }

    public static ImmutableInputGroupCallStream of(InputGroupCall call, long timeMs, int scale) {
        return new ImmutableInputGroupCallStream(call, timeMs, scale);
    }

    public static ImmutableInputGroupCallStream copyOf(InputGroupCallStream instance) {
        if (instance instanceof ImmutableInputGroupCallStream) {
            return (ImmutableInputGroupCallStream)instance;
        }
        return ImmutableInputGroupCallStream.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_TIME_MS = 2L;
        private static final long INIT_BIT_SCALE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputGroupCall call;
        private long timeMs;
        private int scale;
        private Integer videoChannel;
        private Integer videoQuality;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputGroupCallStream instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputGroupCallStream) {
                instance = (InputGroupCallStream)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.scale(instance.scale());
                Integer videoChannelValue = instance.videoChannel();
                if (videoChannelValue != null) {
                    this.videoChannel(videoChannelValue);
                }
                this.timeMs(instance.timeMs());
                Integer videoQualityValue = instance.videoQuality();
                if (videoQualityValue != null) {
                    this.videoQuality(videoQualityValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeMs(long timeMs) {
            this.timeMs = timeMs;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scale(int scale) {
            this.scale = scale;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder videoChannel(@Nullable Integer videoChannel) {
            this.videoChannel = videoChannel;
            return this;
        }

        public final Builder videoQuality(@Nullable Integer videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        public ImmutableInputGroupCallStream build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputGroupCallStream(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timeMs");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("scale");
            }
            return "Cannot build InputGroupCallStream, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputGroupCallStream.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputGroupCallStream.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputGroupCallStream, attribute initializers form cycle " + attributes;
        }
    }
}

