/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputInvoice;
import telegram4j.tl.InputInvoiceMessage;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputInvoiceMessage
implements InputInvoiceMessage {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;

    private ImmutableInputInvoiceMessage(InputPeer peer, int msgId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.identifier = InputInvoiceMessage.super.identifier();
    }

    private ImmutableInputInvoiceMessage(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputInvoiceMessage.super.identifier();
    }

    private ImmutableInputInvoiceMessage(int identifier, InputPeer peer, int msgId) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    public final ImmutableInputInvoiceMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputInvoiceMessage(value, this.peer, this.msgId);
    }

    public final ImmutableInputInvoiceMessage withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInputInvoiceMessage(this.identifier, newValue, this.msgId);
    }

    public final ImmutableInputInvoiceMessage withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableInputInvoiceMessage(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputInvoiceMessage && this.equalTo(0, (ImmutableInputInvoiceMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputInvoiceMessage another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        return h;
    }

    public String toString() {
        return "InputInvoiceMessage{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + "}";
    }

    public static ImmutableInputInvoiceMessage of(InputPeer peer, int msgId) {
        return new ImmutableInputInvoiceMessage(peer, msgId);
    }

    public static ImmutableInputInvoiceMessage copyOf(InputInvoiceMessage instance) {
        if (instance instanceof ImmutableInputInvoiceMessage) {
            return (ImmutableInputInvoiceMessage)instance;
        }
        return ImmutableInputInvoiceMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int msgId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputInvoiceMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputInvoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputInvoiceMessage) {
                instance = (InputInvoiceMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.peer(instance.peer());
            }
            if (object instanceof InputInvoice) {
                instance = (InputInvoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputInvoiceMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputInvoiceMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build InputInvoiceMessage, some of required attributes are not set " + attributes;
        }
    }
}

