/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputInvoice;
import telegram4j.tl.InputInvoiceSlug;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputInvoiceSlug
implements InputInvoiceSlug {
    private final int identifier;
    private final String slug;

    private ImmutableInputInvoiceSlug(String slug) {
        this.slug = Objects.requireNonNull(slug, "slug");
        this.identifier = InputInvoiceSlug.super.identifier();
    }

    private ImmutableInputInvoiceSlug(Builder builder) {
        this.slug = builder.slug;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputInvoiceSlug.super.identifier();
    }

    private ImmutableInputInvoiceSlug(int identifier, String slug) {
        this.identifier = identifier;
        this.slug = slug;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    public final ImmutableInputInvoiceSlug withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputInvoiceSlug(value, this.slug);
    }

    public final ImmutableInputInvoiceSlug withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableInputInvoiceSlug(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputInvoiceSlug && this.equalTo(0, (ImmutableInputInvoiceSlug)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputInvoiceSlug another) {
        return this.identifier == another.identifier && this.slug.equals(another.slug);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.slug.hashCode();
        return h;
    }

    public String toString() {
        return "InputInvoiceSlug{identifier=" + this.identifier + ", slug=" + this.slug + "}";
    }

    public static ImmutableInputInvoiceSlug of(String slug) {
        return new ImmutableInputInvoiceSlug(slug);
    }

    public static ImmutableInputInvoiceSlug copyOf(InputInvoiceSlug instance) {
        if (instance instanceof ImmutableInputInvoiceSlug) {
            return (ImmutableInputInvoiceSlug)instance;
        }
        return ImmutableInputInvoiceSlug.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SLUG = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String slug;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputInvoiceSlug instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputInvoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputInvoiceSlug) {
                instance = (InputInvoiceSlug)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.slug(instance.slug());
            }
            if (object instanceof InputInvoice) {
                instance = (InputInvoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputInvoiceSlug build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputInvoiceSlug(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("slug");
            }
            return "Cannot build InputInvoiceSlug, some of required attributes are not set " + attributes;
        }
    }
}

