/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputKeyboardButtonUrlAuth;
import telegram4j.tl.InputUser;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputKeyboardButtonUrlAuth
implements InputKeyboardButtonUrlAuth {
    private final int identifier;
    private final int flags;
    private final boolean requestWriteAccess;
    private final String text;
    @Nullable
    private final String fwdText;
    private final String url;
    private final InputUser bot;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputKeyboardButtonUrlAuth(String text, String url, InputUser bot) {
        this.text = Objects.requireNonNull(text, "text");
        this.url = Objects.requireNonNull(url, "url");
        this.bot = Objects.requireNonNull(bot, "bot");
        this.fwdText = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requestWriteAccess = this.initShim.requestWriteAccess();
        this.initShim = null;
    }

    private ImmutableInputKeyboardButtonUrlAuth(Builder builder) {
        this.text = builder.text;
        this.fwdText = builder.fwdText;
        this.url = builder.url;
        this.bot = builder.bot;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.requestWriteAccessIsSet()) {
            this.initShim.requestWriteAccess(builder.requestWriteAccess);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requestWriteAccess = this.initShim.requestWriteAccess();
        this.initShim = null;
    }

    private ImmutableInputKeyboardButtonUrlAuth(int identifier, int flags, boolean requestWriteAccess, String text, @Nullable String fwdText, String url, InputUser bot) {
        this.identifier = identifier;
        this.flags = flags;
        this.requestWriteAccess = requestWriteAccess;
        this.text = text;
        this.fwdText = fwdText;
        this.url = url;
        this.bot = bot;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputKeyboardButtonUrlAuth.super.identifier();
    }

    private int flagsInitialize() {
        return InputKeyboardButtonUrlAuth.super.flags();
    }

    private boolean requestWriteAccessInitialize() {
        return InputKeyboardButtonUrlAuth.super.requestWriteAccess();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean requestWriteAccess() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestWriteAccess() : this.requestWriteAccess;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @Nullable
    public String fwdText() {
        return this.fwdText;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    public final ImmutableInputKeyboardButtonUrlAuth withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputKeyboardButtonUrlAuth(value, this.flags, this.requestWriteAccess, this.text, this.fwdText, this.url, this.bot);
    }

    public final ImmutableInputKeyboardButtonUrlAuth withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputKeyboardButtonUrlAuth(this.identifier, value, this.requestWriteAccess, this.text, this.fwdText, this.url, this.bot);
    }

    public final ImmutableInputKeyboardButtonUrlAuth withRequestWriteAccess(boolean value) {
        if (this.requestWriteAccess == value) {
            return this;
        }
        return new ImmutableInputKeyboardButtonUrlAuth(this.identifier, this.flags, value, this.text, this.fwdText, this.url, this.bot);
    }

    public final ImmutableInputKeyboardButtonUrlAuth withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableInputKeyboardButtonUrlAuth(this.identifier, this.flags, this.requestWriteAccess, newValue, this.fwdText, this.url, this.bot);
    }

    public final ImmutableInputKeyboardButtonUrlAuth withFwdText(@Nullable String value) {
        if (Objects.equals(this.fwdText, value)) {
            return this;
        }
        return new ImmutableInputKeyboardButtonUrlAuth(this.identifier, this.flags, this.requestWriteAccess, this.text, value, this.url, this.bot);
    }

    public final ImmutableInputKeyboardButtonUrlAuth withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableInputKeyboardButtonUrlAuth(this.identifier, this.flags, this.requestWriteAccess, this.text, this.fwdText, newValue, this.bot);
    }

    public final ImmutableInputKeyboardButtonUrlAuth withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableInputKeyboardButtonUrlAuth(this.identifier, this.flags, this.requestWriteAccess, this.text, this.fwdText, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputKeyboardButtonUrlAuth && this.equalTo(0, (ImmutableInputKeyboardButtonUrlAuth)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputKeyboardButtonUrlAuth another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.requestWriteAccess == another.requestWriteAccess && this.text.equals(another.text) && Objects.equals(this.fwdText, another.fwdText) && this.url.equals(another.url) && this.bot.equals(another.bot);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.requestWriteAccess);
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Objects.hashCode(this.fwdText);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.bot.hashCode();
        return h;
    }

    public String toString() {
        return "InputKeyboardButtonUrlAuth{identifier=" + this.identifier + ", flags=" + this.flags + ", requestWriteAccess=" + this.requestWriteAccess + ", text=" + this.text + ", fwdText=" + this.fwdText + ", url=" + this.url + ", bot=" + this.bot + "}";
    }

    public static ImmutableInputKeyboardButtonUrlAuth of(String text, String url, InputUser bot) {
        return new ImmutableInputKeyboardButtonUrlAuth(text, url, bot);
    }

    public static ImmutableInputKeyboardButtonUrlAuth copyOf(InputKeyboardButtonUrlAuth instance) {
        if (instance instanceof ImmutableInputKeyboardButtonUrlAuth) {
            return (ImmutableInputKeyboardButtonUrlAuth)instance;
        }
        return ImmutableInputKeyboardButtonUrlAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_BOT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REQUEST_WRITE_ACCESS = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean requestWriteAccess;
        private String text;
        private String fwdText;
        private String url;
        private InputUser bot;

        private Builder() {
        }

        public final Builder from(InputKeyboardButtonUrlAuth instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            KeyboardButton instance;
            long bits = 0L;
            if (object instanceof InputKeyboardButtonUrlAuth) {
                String fwdTextValue;
                instance = (InputKeyboardButtonUrlAuth)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((fwdTextValue = instance.fwdText()) != null) {
                    this.fwdText(fwdTextValue);
                }
                this.bot(instance.bot());
                this.flags(instance.flags());
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                this.requestWriteAccess(instance.requestWriteAccess());
                this.url(instance.url());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder requestWriteAccess(boolean requestWriteAccess) {
            this.requestWriteAccess = requestWriteAccess;
            this.optBits |= 4L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fwdText(@Nullable String fwdText) {
            this.fwdText = fwdText;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputKeyboardButtonUrlAuth build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputKeyboardButtonUrlAuth(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean requestWriteAccessIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bot");
            }
            return "Cannot build InputKeyboardButtonUrlAuth, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte requestWriteAccessBuildStage = 0;
        private boolean requestWriteAccess;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputKeyboardButtonUrlAuth.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputKeyboardButtonUrlAuth.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean requestWriteAccess() {
            if (this.requestWriteAccessBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestWriteAccessBuildStage == 0) {
                this.requestWriteAccessBuildStage = (byte)-1;
                this.requestWriteAccess = ImmutableInputKeyboardButtonUrlAuth.this.requestWriteAccessInitialize();
                this.requestWriteAccessBuildStage = 1;
            }
            return this.requestWriteAccess;
        }

        void requestWriteAccess(boolean requestWriteAccess) {
            this.requestWriteAccess = requestWriteAccess;
            this.requestWriteAccessBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.requestWriteAccessBuildStage == -1) {
                attributes.add("requestWriteAccess");
            }
            return "Cannot build InputKeyboardButtonUrlAuth, attribute initializers form cycle " + attributes;
        }
    }
}

