/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaContact;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaContact
implements InputMediaContact {
    private final int identifier;
    private final String phoneNumber;
    private final String firstName;
    private final String lastName;
    private final String vcard;

    private ImmutableInputMediaContact(String phoneNumber, String firstName, String lastName, String vcard) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.vcard = Objects.requireNonNull(vcard, "vcard");
        this.identifier = InputMediaContact.super.identifier();
    }

    private ImmutableInputMediaContact(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.vcard = builder.vcard;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMediaContact.super.identifier();
    }

    private ImmutableInputMediaContact(int identifier, String phoneNumber, String firstName, String lastName, String vcard) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vcard = vcard;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    @Override
    public String vcard() {
        return this.vcard;
    }

    public final ImmutableInputMediaContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaContact(value, this.phoneNumber, this.firstName, this.lastName, this.vcard);
    }

    public final ImmutableInputMediaContact withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaContact(this.identifier, newValue, this.firstName, this.lastName, this.vcard);
    }

    public final ImmutableInputMediaContact withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaContact(this.identifier, this.phoneNumber, newValue, this.lastName, this.vcard);
    }

    public final ImmutableInputMediaContact withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaContact(this.identifier, this.phoneNumber, this.firstName, newValue, this.vcard);
    }

    public final ImmutableInputMediaContact withVcard(String value) {
        String newValue = Objects.requireNonNull(value, "vcard");
        if (this.vcard.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaContact(this.identifier, this.phoneNumber, this.firstName, this.lastName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaContact && this.equalTo(0, (ImmutableInputMediaContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaContact another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.vcard.equals(another.vcard);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        h += (h << 5) + this.vcard.hashCode();
        return h;
    }

    public String toString() {
        return "InputMediaContact{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", vcard=" + this.vcard + "}";
    }

    public static ImmutableInputMediaContact of(String phoneNumber, String firstName, String lastName, String vcard) {
        return new ImmutableInputMediaContact(phoneNumber, firstName, lastName, vcard);
    }

    public static ImmutableInputMediaContact copyOf(InputMediaContact instance) {
        if (instance instanceof ImmutableInputMediaContact) {
            return (ImmutableInputMediaContact)instance;
        }
        return ImmutableInputMediaContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_FIRST_NAME = 2L;
        private static final long INIT_BIT_LAST_NAME = 4L;
        private static final long INIT_BIT_VCARD = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String firstName;
        private String lastName;
        private String vcard;

        private Builder() {
        }

        public final Builder from(InputMediaContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaContact) {
                instance = (InputMediaContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.phoneNumber(instance.phoneNumber());
                this.vcard(instance.vcard());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder vcard(String vcard) {
            this.vcard = Objects.requireNonNull(vcard, "vcard");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInputMediaContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("vcard");
            }
            return "Cannot build InputMediaContact, some of required attributes are not set " + attributes;
        }
    }
}

