/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaDice;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaDice
implements InputMediaDice {
    private final int identifier;
    private final String emoticon;

    private ImmutableInputMediaDice(String emoticon) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.identifier = InputMediaDice.super.identifier();
    }

    private ImmutableInputMediaDice(Builder builder) {
        this.emoticon = builder.emoticon;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMediaDice.super.identifier();
    }

    private ImmutableInputMediaDice(int identifier, String emoticon) {
        this.identifier = identifier;
        this.emoticon = emoticon;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    public final ImmutableInputMediaDice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaDice(value, this.emoticon);
    }

    public final ImmutableInputMediaDice withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaDice(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaDice && this.equalTo(0, (ImmutableInputMediaDice)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaDice another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        return h;
    }

    public String toString() {
        return "InputMediaDice{identifier=" + this.identifier + ", emoticon=" + this.emoticon + "}";
    }

    public static ImmutableInputMediaDice of(String emoticon) {
        return new ImmutableInputMediaDice(emoticon);
    }

    public static ImmutableInputMediaDice copyOf(InputMediaDice instance) {
        if (instance instanceof ImmutableInputMediaDice) {
            return (ImmutableInputMediaDice)instance;
        }
        return ImmutableInputMediaDice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String emoticon;

        private Builder() {
        }

        public final Builder from(InputMediaDice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaDice) {
                instance = (InputMediaDice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.emoticon(instance.emoticon());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputMediaDice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaDice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build InputMediaDice, some of required attributes are not set " + attributes;
        }
    }
}

