/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaEmpty
implements InputMediaEmpty {
    private final int identifier;
    private static final ImmutableInputMediaEmpty INSTANCE = ImmutableInputMediaEmpty.validate(new ImmutableInputMediaEmpty());

    private ImmutableInputMediaEmpty() {
        this.identifier = InputMediaEmpty.super.identifier();
    }

    private ImmutableInputMediaEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMediaEmpty.super.identifier();
    }

    private ImmutableInputMediaEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMediaEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMediaEmpty.validate(new ImmutableInputMediaEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaEmpty && this.equalTo(0, (ImmutableInputMediaEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMediaEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMediaEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputMediaEmpty validate(ImmutableInputMediaEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMediaEmpty copyOf(InputMediaEmpty instance) {
        if (instance instanceof ImmutableInputMediaEmpty) {
            return (ImmutableInputMediaEmpty)instance;
        }
        return ImmutableInputMediaEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputMediaEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaEmpty) {
                instance = (InputMediaEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMediaEmpty build() {
            return ImmutableInputMediaEmpty.validate(new ImmutableInputMediaEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

