/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGame;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaGame;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaGame
implements InputMediaGame {
    private final int identifier;
    private final InputGame id;

    private ImmutableInputMediaGame(InputGame id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = InputMediaGame.super.identifier();
    }

    private ImmutableInputMediaGame(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMediaGame.super.identifier();
    }

    private ImmutableInputMediaGame(int identifier, InputGame id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGame id() {
        return this.id;
    }

    public final ImmutableInputMediaGame withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaGame(value, this.id);
    }

    public final ImmutableInputMediaGame withId(InputGame value) {
        if (this.id == value) {
            return this;
        }
        InputGame newValue = Objects.requireNonNull(value, "id");
        return new ImmutableInputMediaGame(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaGame && this.equalTo(0, (ImmutableInputMediaGame)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaGame another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "InputMediaGame{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableInputMediaGame of(InputGame id) {
        return new ImmutableInputMediaGame(id);
    }

    public static ImmutableInputMediaGame copyOf(InputMediaGame instance) {
        if (instance instanceof ImmutableInputMediaGame) {
            return (ImmutableInputMediaGame)instance;
        }
        return ImmutableInputMediaGame.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGame id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMediaGame instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMediaGame) {
                instance = (InputMediaGame)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputGame id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputMediaGame build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaGame(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build InputMediaGame, some of required attributes are not set " + attributes;
        }
    }
}

