/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaGeoLive;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaGeoLive
implements InputMediaGeoLive {
    private final int identifier;
    private final int flags;
    private final boolean stopped;
    private final InputGeoPoint geoPoint;
    @Nullable
    private final Integer heading;
    @Nullable
    private final Integer period;
    @Nullable
    private final Integer proximityNotificationRadius;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputMediaGeoLive(InputGeoPoint geoPoint) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.heading = null;
        this.period = null;
        this.proximityNotificationRadius = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.stopped = this.initShim.stopped();
        this.initShim = null;
    }

    private ImmutableInputMediaGeoLive(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.heading = builder.heading;
        this.period = builder.period;
        this.proximityNotificationRadius = builder.proximityNotificationRadius;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.stoppedIsSet()) {
            this.initShim.stopped(builder.stopped);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.stopped = this.initShim.stopped();
        this.initShim = null;
    }

    private ImmutableInputMediaGeoLive(int identifier, int flags, boolean stopped, InputGeoPoint geoPoint, @Nullable Integer heading, @Nullable Integer period, @Nullable Integer proximityNotificationRadius) {
        this.identifier = identifier;
        this.flags = flags;
        this.stopped = stopped;
        this.geoPoint = geoPoint;
        this.heading = heading;
        this.period = period;
        this.proximityNotificationRadius = proximityNotificationRadius;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMediaGeoLive.super.identifier();
    }

    private int flagsInitialize() {
        return InputMediaGeoLive.super.flags();
    }

    private boolean stoppedInitialize() {
        return InputMediaGeoLive.super.stopped();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean stopped() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stopped() : this.stopped;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    @Nullable
    public Integer heading() {
        return this.heading;
    }

    @Override
    @Nullable
    public Integer period() {
        return this.period;
    }

    @Override
    @Nullable
    public Integer proximityNotificationRadius() {
        return this.proximityNotificationRadius;
    }

    public final ImmutableInputMediaGeoLive withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaGeoLive(value, this.flags, this.stopped, this.geoPoint, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableInputMediaGeoLive withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputMediaGeoLive(this.identifier, value, this.stopped, this.geoPoint, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableInputMediaGeoLive withStopped(boolean value) {
        if (this.stopped == value) {
            return this;
        }
        return new ImmutableInputMediaGeoLive(this.identifier, this.flags, value, this.geoPoint, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableInputMediaGeoLive withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableInputMediaGeoLive(this.identifier, this.flags, this.stopped, newValue, this.heading, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableInputMediaGeoLive withHeading(@Nullable Integer value) {
        if (Objects.equals(this.heading, value)) {
            return this;
        }
        return new ImmutableInputMediaGeoLive(this.identifier, this.flags, this.stopped, this.geoPoint, value, this.period, this.proximityNotificationRadius);
    }

    public final ImmutableInputMediaGeoLive withPeriod(@Nullable Integer value) {
        if (Objects.equals(this.period, value)) {
            return this;
        }
        return new ImmutableInputMediaGeoLive(this.identifier, this.flags, this.stopped, this.geoPoint, this.heading, value, this.proximityNotificationRadius);
    }

    public final ImmutableInputMediaGeoLive withProximityNotificationRadius(@Nullable Integer value) {
        if (Objects.equals(this.proximityNotificationRadius, value)) {
            return this;
        }
        return new ImmutableInputMediaGeoLive(this.identifier, this.flags, this.stopped, this.geoPoint, this.heading, this.period, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaGeoLive && this.equalTo(0, (ImmutableInputMediaGeoLive)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaGeoLive another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.stopped == another.stopped && this.geoPoint.equals(another.geoPoint) && Objects.equals(this.heading, another.heading) && Objects.equals(this.period, another.period) && Objects.equals(this.proximityNotificationRadius, another.proximityNotificationRadius);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.stopped);
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + Objects.hashCode(this.heading);
        h += (h << 5) + Objects.hashCode(this.period);
        h += (h << 5) + Objects.hashCode(this.proximityNotificationRadius);
        return h;
    }

    public String toString() {
        return "InputMediaGeoLive{identifier=" + this.identifier + ", flags=" + this.flags + ", stopped=" + this.stopped + ", geoPoint=" + this.geoPoint + ", heading=" + this.heading + ", period=" + this.period + ", proximityNotificationRadius=" + this.proximityNotificationRadius + "}";
    }

    public static ImmutableInputMediaGeoLive of(InputGeoPoint geoPoint) {
        return new ImmutableInputMediaGeoLive(geoPoint);
    }

    public static ImmutableInputMediaGeoLive copyOf(InputMediaGeoLive instance) {
        if (instance instanceof ImmutableInputMediaGeoLive) {
            return (ImmutableInputMediaGeoLive)instance;
        }
        return ImmutableInputMediaGeoLive.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_STOPPED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean stopped;
        private InputGeoPoint geoPoint;
        private Integer heading;
        private Integer period;
        private Integer proximityNotificationRadius;

        private Builder() {
        }

        public final Builder from(InputMediaGeoLive instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaGeoLive) {
                Integer headingValue;
                instance = (InputMediaGeoLive)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stopped(instance.stopped());
                Integer periodValue = instance.period();
                if (periodValue != null) {
                    this.period(periodValue);
                }
                if ((headingValue = instance.heading()) != null) {
                    this.heading(headingValue);
                }
                this.flags(instance.flags());
                this.geoPoint(instance.geoPoint());
                Integer proximityNotificationRadiusValue = instance.proximityNotificationRadius();
                if (proximityNotificationRadiusValue != null) {
                    this.proximityNotificationRadius(proximityNotificationRadiusValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder stopped(boolean stopped) {
            this.stopped = stopped;
            this.optBits |= 4L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder heading(@Nullable Integer heading) {
            this.heading = heading;
            return this;
        }

        public final Builder period(@Nullable Integer period) {
            this.period = period;
            return this;
        }

        public final Builder proximityNotificationRadius(@Nullable Integer proximityNotificationRadius) {
            this.proximityNotificationRadius = proximityNotificationRadius;
            return this;
        }

        public ImmutableInputMediaGeoLive build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaGeoLive(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean stoppedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            return "Cannot build InputMediaGeoLive, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte stoppedBuildStage = 0;
        private boolean stopped;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMediaGeoLive.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMediaGeoLive.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean stopped() {
            if (this.stoppedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stoppedBuildStage == 0) {
                this.stoppedBuildStage = (byte)-1;
                this.stopped = ImmutableInputMediaGeoLive.this.stoppedInitialize();
                this.stoppedBuildStage = 1;
            }
            return this.stopped;
        }

        void stopped(boolean stopped) {
            this.stopped = stopped;
            this.stoppedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.stoppedBuildStage == -1) {
                attributes.add("stopped");
            }
            return "Cannot build InputMediaGeoLive, attribute initializers form cycle " + attributes;
        }
    }
}

