/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaGeoPoint;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaGeoPoint
implements InputMediaGeoPoint {
    private final int identifier;
    private final InputGeoPoint geoPoint;

    private ImmutableInputMediaGeoPoint(InputGeoPoint geoPoint) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.identifier = InputMediaGeoPoint.super.identifier();
    }

    private ImmutableInputMediaGeoPoint(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMediaGeoPoint.super.identifier();
    }

    private ImmutableInputMediaGeoPoint(int identifier, InputGeoPoint geoPoint) {
        this.identifier = identifier;
        this.geoPoint = geoPoint;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    public final ImmutableInputMediaGeoPoint withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaGeoPoint(value, this.geoPoint);
    }

    public final ImmutableInputMediaGeoPoint withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableInputMediaGeoPoint(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaGeoPoint && this.equalTo(0, (ImmutableInputMediaGeoPoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaGeoPoint another) {
        return this.identifier == another.identifier && this.geoPoint.equals(another.geoPoint);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.geoPoint.hashCode();
        return h;
    }

    public String toString() {
        return "InputMediaGeoPoint{identifier=" + this.identifier + ", geoPoint=" + this.geoPoint + "}";
    }

    public static ImmutableInputMediaGeoPoint of(InputGeoPoint geoPoint) {
        return new ImmutableInputMediaGeoPoint(geoPoint);
    }

    public static ImmutableInputMediaGeoPoint copyOf(InputMediaGeoPoint instance) {
        if (instance instanceof ImmutableInputMediaGeoPoint) {
            return (ImmutableInputMediaGeoPoint)instance;
        }
        return ImmutableInputMediaGeoPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGeoPoint geoPoint;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMediaGeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMediaGeoPoint) {
                instance = (InputMediaGeoPoint)object;
                this.geoPoint(instance.geoPoint());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputMediaGeoPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaGeoPoint(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            return "Cannot build InputMediaGeoPoint, some of required attributes are not set " + attributes;
        }
    }
}

