/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaInvoice;
import telegram4j.tl.InputWebDocument;
import telegram4j.tl.Invoice;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaInvoice
implements InputMediaInvoice {
    private final int identifier;
    private final int flags;
    private final String title;
    private final String description;
    @Nullable
    private final InputWebDocument photo;
    private final Invoice invoice;
    private final ByteBuf payload;
    private final String provider;
    private final DataJSON providerData;
    @Nullable
    private final String startParam;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputMediaInvoice(String title, String description, Invoice invoice, String provider, DataJSON providerData) {
        this.title = Objects.requireNonNull(title, "title");
        this.description = Objects.requireNonNull(description, "description");
        this.invoice = Objects.requireNonNull(invoice, "invoice");
        this.provider = Objects.requireNonNull(provider, "provider");
        this.providerData = Objects.requireNonNull(providerData, "providerData");
        this.photo = null;
        this.payload = null;
        this.startParam = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaInvoice(Builder builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.photo = builder.photo;
        this.invoice = builder.invoice;
        this.payload = builder.payload_build();
        this.provider = builder.provider;
        this.providerData = builder.providerData;
        this.startParam = builder.startParam;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaInvoice(int identifier, int flags, String title, String description, @Nullable InputWebDocument photo, Invoice invoice, ByteBuf payload, String provider, DataJSON providerData, @Nullable String startParam) {
        this.identifier = identifier;
        this.flags = flags;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.invoice = invoice;
        this.payload = payload;
        this.provider = provider;
        this.providerData = providerData;
        this.startParam = startParam;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMediaInvoice.super.identifier();
    }

    private int flagsInitialize() {
        return InputMediaInvoice.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public InputWebDocument photo() {
        return this.photo;
    }

    @Override
    public Invoice invoice() {
        return this.invoice;
    }

    @Override
    public ByteBuf payload() {
        return this.payload.duplicate();
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public DataJSON providerData() {
        return this.providerData;
    }

    @Override
    @Nullable
    public String startParam() {
        return this.startParam;
    }

    public final ImmutableInputMediaInvoice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaInvoice(value, this.flags, this.title, this.description, this.photo, this.invoice, this.payload, this.provider, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, value, this.title, this.description, this.photo, this.invoice, this.payload, this.provider, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, newValue, this.description, this.photo, this.invoice, this.payload, this.provider, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, newValue, this.photo, this.invoice, this.payload, this.provider, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withPhoto(@Nullable InputWebDocument value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, this.description, value, this.invoice, this.payload, this.provider, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withInvoice(Invoice value) {
        if (this.invoice == value) {
            return this;
        }
        Invoice newValue = Objects.requireNonNull(value, "invoice");
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, this.description, this.photo, newValue, this.payload, this.provider, this.providerData, this.startParam);
    }

    public ImmutableInputMediaInvoice withPayload(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.payload == newValue) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, this.description, this.photo, this.invoice, newValue, this.provider, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withProvider(String value) {
        String newValue = Objects.requireNonNull(value, "provider");
        if (this.provider.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, this.description, this.photo, this.invoice, this.payload, newValue, this.providerData, this.startParam);
    }

    public final ImmutableInputMediaInvoice withProviderData(DataJSON value) {
        if (this.providerData == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "providerData");
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, this.description, this.photo, this.invoice, this.payload, this.provider, newValue, this.startParam);
    }

    public final ImmutableInputMediaInvoice withStartParam(@Nullable String value) {
        if (Objects.equals(this.startParam, value)) {
            return this;
        }
        return new ImmutableInputMediaInvoice(this.identifier, this.flags, this.title, this.description, this.photo, this.invoice, this.payload, this.provider, this.providerData, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaInvoice && this.equalTo(0, (ImmutableInputMediaInvoice)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaInvoice another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.title.equals(another.title) && this.description.equals(another.description) && Objects.equals(this.photo, another.photo) && this.invoice.equals(another.invoice) && this.payload().equals((Object)another.payload()) && this.provider.equals(another.provider) && this.providerData.equals(another.providerData) && Objects.equals(this.startParam, another.startParam);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + this.invoice.hashCode();
        h += (h << 5) + this.payload().hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.providerData.hashCode();
        h += (h << 5) + Objects.hashCode(this.startParam);
        return h;
    }

    public String toString() {
        return "InputMediaInvoice{identifier=" + this.identifier + ", flags=" + this.flags + ", title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", invoice=" + this.invoice + ", payload=" + ByteBufUtil.hexDump((ByteBuf)this.payload) + ", provider=" + this.provider + ", providerData=" + this.providerData + ", startParam=" + this.startParam + "}";
    }

    public static ImmutableInputMediaInvoice of(String title, String description, Invoice invoice, String provider, DataJSON providerData) {
        return new ImmutableInputMediaInvoice(title, description, invoice, provider, providerData);
    }

    public static ImmutableInputMediaInvoice copyOf(InputMediaInvoice instance) {
        if (instance instanceof ImmutableInputMediaInvoice) {
            return (ImmutableInputMediaInvoice)instance;
        }
        return ImmutableInputMediaInvoice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_INVOICE = 4L;
        private static final long INIT_BIT_PROVIDER = 8L;
        private static final long INIT_BIT_PROVIDER_DATA = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 31L;
        private long optBits;
        private ByteBuf payload_value = null;
        private int identifier;
        private int flags;
        private String title;
        private String description;
        private InputWebDocument photo;
        private Invoice invoice;
        private String provider;
        private DataJSON providerData;
        private String startParam;

        private Builder() {
        }

        public final Builder from(InputMediaInvoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaInvoice) {
                String startParamValue;
                instance = (InputMediaInvoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((startParamValue = instance.startParam()) != null) {
                    this.startParam(startParamValue);
                }
                this.payload(instance.payload());
                this.provider(instance.provider());
                this.providerData(instance.providerData());
                this.flags(instance.flags());
                this.description(instance.description());
                InputWebDocument photoValue = instance.photo();
                if (photoValue != null) {
                    this.photo(photoValue);
                }
                this.invoice(instance.invoice());
                this.title(instance.title());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(@Nullable InputWebDocument photo) {
            this.photo = photo;
            return this;
        }

        public final Builder invoice(Invoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder payload(ByteBuf value) {
            this.payload_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder providerData(DataJSON providerData) {
            this.providerData = Objects.requireNonNull(providerData, "providerData");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder startParam(@Nullable String startParam) {
            this.startParam = startParam;
            return this;
        }

        public ImmutableInputMediaInvoice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaInvoice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("invoice");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("providerData");
            }
            return "Cannot build InputMediaInvoice, some of required attributes are not set " + attributes;
        }

        private ByteBuf payload_build() {
            return Objects.requireNonNull(this.payload_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMediaInvoice.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMediaInvoice.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputMediaInvoice, attribute initializers form cycle " + attributes;
        }
    }
}

