/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaPhotoExternal;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaPhotoExternal
implements InputMediaPhotoExternal {
    private final int identifier;
    private final int flags;
    private final String url;
    @Nullable
    private final Integer ttlSeconds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputMediaPhotoExternal(String url) {
        this.url = Objects.requireNonNull(url, "url");
        this.ttlSeconds = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaPhotoExternal(Builder builder) {
        this.url = builder.url;
        this.ttlSeconds = builder.ttlSeconds;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaPhotoExternal(int identifier, int flags, String url, @Nullable Integer ttlSeconds) {
        this.identifier = identifier;
        this.flags = flags;
        this.url = url;
        this.ttlSeconds = ttlSeconds;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMediaPhotoExternal.super.identifier();
    }

    private int flagsInitialize() {
        return InputMediaPhotoExternal.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public Integer ttlSeconds() {
        return this.ttlSeconds;
    }

    public final ImmutableInputMediaPhotoExternal withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaPhotoExternal(value, this.flags, this.url, this.ttlSeconds);
    }

    public final ImmutableInputMediaPhotoExternal withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputMediaPhotoExternal(this.identifier, value, this.url, this.ttlSeconds);
    }

    public final ImmutableInputMediaPhotoExternal withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaPhotoExternal(this.identifier, this.flags, newValue, this.ttlSeconds);
    }

    public final ImmutableInputMediaPhotoExternal withTtlSeconds(@Nullable Integer value) {
        if (Objects.equals(this.ttlSeconds, value)) {
            return this;
        }
        return new ImmutableInputMediaPhotoExternal(this.identifier, this.flags, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaPhotoExternal && this.equalTo(0, (ImmutableInputMediaPhotoExternal)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaPhotoExternal another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.url.equals(another.url) && Objects.equals(this.ttlSeconds, another.ttlSeconds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Objects.hashCode(this.ttlSeconds);
        return h;
    }

    public String toString() {
        return "InputMediaPhotoExternal{identifier=" + this.identifier + ", flags=" + this.flags + ", url=" + this.url + ", ttlSeconds=" + this.ttlSeconds + "}";
    }

    public static ImmutableInputMediaPhotoExternal of(String url) {
        return new ImmutableInputMediaPhotoExternal(url);
    }

    public static ImmutableInputMediaPhotoExternal copyOf(InputMediaPhotoExternal instance) {
        if (instance instanceof ImmutableInputMediaPhotoExternal) {
            return (ImmutableInputMediaPhotoExternal)instance;
        }
        return ImmutableInputMediaPhotoExternal.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private String url;
        private Integer ttlSeconds;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMediaPhotoExternal instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMediaPhotoExternal) {
                Integer ttlSecondsValue;
                instance = (InputMediaPhotoExternal)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((ttlSecondsValue = instance.ttlSeconds()) != null) {
                    this.ttlSeconds(ttlSecondsValue);
                }
                this.url(instance.url());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ttlSeconds(@Nullable Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public ImmutableInputMediaPhotoExternal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaPhotoExternal(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build InputMediaPhotoExternal, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMediaPhotoExternal.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMediaPhotoExternal.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputMediaPhotoExternal, attribute initializers form cycle " + attributes;
        }
    }
}

