/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaPoll;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.Poll;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaPoll
implements InputMediaPoll {
    private final int identifier;
    private final int flags;
    private final Poll poll;
    private final List<ByteBuf> correctAnswers;
    @Nullable
    private final String solution;
    @Nullable
    private final List<MessageEntity> solutionEntities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputMediaPoll(Poll poll) {
        this.poll = Objects.requireNonNull(poll, "poll");
        this.correctAnswers = null;
        this.solution = null;
        this.solutionEntities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaPoll(Builder builder) {
        this.poll = builder.poll;
        this.correctAnswers = builder.correctAnswers_build();
        this.solution = builder.solution;
        List<MessageEntity> list = this.solutionEntities = builder.solutionEntities == null ? null : ImmutableInputMediaPoll.createUnmodifiableList(true, builder.solutionEntities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaPoll(int identifier, int flags, Poll poll, List<ByteBuf> correctAnswers, @Nullable String solution, @Nullable List<MessageEntity> solutionEntities) {
        this.identifier = identifier;
        this.flags = flags;
        this.poll = poll;
        this.correctAnswers = correctAnswers;
        this.solution = solution;
        this.solutionEntities = solutionEntities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMediaPoll.super.identifier();
    }

    private int flagsInitialize() {
        return InputMediaPoll.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public Poll poll() {
        return this.poll;
    }

    @Override
    public Optional<List<ByteBuf>> correctAnswers() {
        return Optional.ofNullable(this.correctAnswers).map(l -> l.stream().map(ByteBuf::duplicate).collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public String solution() {
        return this.solution;
    }

    @Override
    @Nullable
    public List<MessageEntity> solutionEntities() {
        return this.solutionEntities;
    }

    public final ImmutableInputMediaPoll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaPoll(value, this.flags, this.poll, this.correctAnswers, this.solution, this.solutionEntities);
    }

    public final ImmutableInputMediaPoll withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputMediaPoll(this.identifier, value, this.poll, this.correctAnswers, this.solution, this.solutionEntities);
    }

    public final ImmutableInputMediaPoll withPoll(Poll value) {
        if (this.poll == value) {
            return this;
        }
        Poll newValue = Objects.requireNonNull(value, "poll");
        return new ImmutableInputMediaPoll(this.identifier, this.flags, newValue, this.correctAnswers, this.solution, this.solutionEntities);
    }

    public ImmutableInputMediaPoll withCorrectAnswers(Optional<? extends Iterable<ByteBuf>> value) {
        List newValue = value.map(i -> StreamSupport.stream(i.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList())).orElse(null);
        if (this.correctAnswers == newValue) {
            return this;
        }
        return new ImmutableInputMediaPoll(this.identifier, this.flags, this.poll, newValue, this.solution, this.solutionEntities);
    }

    public ImmutableInputMediaPoll withCorrectAnswers(Iterable<? extends ByteBuf> value) {
        List<ByteBuf> newValue = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
        if (this.correctAnswers == newValue) {
            return this;
        }
        return new ImmutableInputMediaPoll(this.identifier, this.flags, this.poll, newValue, this.solution, this.solutionEntities);
    }

    public final ImmutableInputMediaPoll withSolution(@Nullable String value) {
        if (Objects.equals(this.solution, value)) {
            return this;
        }
        return new ImmutableInputMediaPoll(this.identifier, this.flags, this.poll, this.correctAnswers, value, this.solutionEntities);
    }

    public final ImmutableInputMediaPoll withSolutionEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableInputMediaPoll(this.identifier, this.flags, this.poll, this.correctAnswers, this.solution, null);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableInputMediaPoll.createUnmodifiableList(false, ImmutableInputMediaPoll.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputMediaPoll(this.identifier, this.flags, this.poll, this.correctAnswers, this.solution, newValue);
    }

    public final ImmutableInputMediaPoll withSolutionEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.solutionEntities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableInputMediaPoll.createUnmodifiableList(false, ImmutableInputMediaPoll.createSafeList(elements, true, false));
        return new ImmutableInputMediaPoll(this.identifier, this.flags, this.poll, this.correctAnswers, this.solution, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaPoll && this.equalTo(0, (ImmutableInputMediaPoll)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaPoll another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.poll.equals(another.poll) && this.correctAnswers().equals(another.correctAnswers()) && Objects.equals(this.solution, another.solution) && Objects.equals(this.solutionEntities, another.solutionEntities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.poll.hashCode();
        h += (h << 5) + this.correctAnswers().hashCode();
        h += (h << 5) + Objects.hashCode(this.solution);
        h += (h << 5) + Objects.hashCode(this.solutionEntities);
        return h;
    }

    public String toString() {
        return "InputMediaPoll{identifier=" + this.identifier + ", flags=" + this.flags + ", poll=" + this.poll + ", correctAnswers=" + this.correctAnswers().map(l -> l.stream().map(ByteBufUtil::hexDump).collect(Collectors.joining(", ", "[", "]"))).toString() + ", solution=" + this.solution + ", solutionEntities=" + this.solutionEntities + "}";
    }

    public static ImmutableInputMediaPoll of(Poll poll) {
        return new ImmutableInputMediaPoll(poll);
    }

    public static ImmutableInputMediaPoll copyOf(InputMediaPoll instance) {
        if (instance instanceof ImmutableInputMediaPoll) {
            return (ImmutableInputMediaPoll)instance;
        }
        return ImmutableInputMediaPoll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_POLL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private Optional<List<ByteBuf>> correctAnswers_value = Optional.empty();
        private int identifier;
        private int flags;
        private Poll poll;
        private String solution;
        private List<MessageEntity> solutionEntities = null;

        private Builder() {
        }

        public final Builder from(InputMediaPoll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaPoll) {
                instance = (InputMediaPoll)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.poll(instance.poll());
                String solutionValue = instance.solution();
                if (solutionValue != null) {
                    this.solution(solutionValue);
                }
                this.correctAnswers(instance.correctAnswers());
                List<MessageEntity> solutionEntitiesValue = instance.solutionEntities();
                if (solutionEntitiesValue != null) {
                    this.addAllSolutionEntities(solutionEntitiesValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder poll(Poll poll) {
            this.poll = Objects.requireNonNull(poll, "poll");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder addCorrectAnswer(ByteBuf value) {
            this.correctAnswers_getOrCreate().add(TlEncodingUtil.copyAsUnpooled((ByteBuf)value));
            return this;
        }

        public Builder addAllCorrectAnswers(Iterable<? extends ByteBuf> value) {
            this.correctAnswers_getOrCreate().addAll(StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder addAllCorrectAnswers(ByteBuf ... value) {
            this.correctAnswers_getOrCreate().addAll(Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder correctAnswers(Optional<? extends Iterable<ByteBuf>> value) {
            this.correctAnswers_value = value.map(i -> StreamSupport.stream(i.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder correctAnswers(@Nullable Iterable<? extends ByteBuf> value) {
            this.correctAnswers_value = Optional.ofNullable(value).map(i -> StreamSupport.stream(i.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder correctAnswers(ByteBuf ... value) {
            this.correctAnswers_value = Optional.ofNullable(value).map(b -> Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public final Builder solution(@Nullable String solution) {
            this.solution = solution;
            return this;
        }

        public final Builder addSolutionEntity(MessageEntity element) {
            if (this.solutionEntities == null) {
                this.solutionEntities = new ArrayList<MessageEntity>();
            }
            this.solutionEntities.add(Objects.requireNonNull(element, "solutionEntities element"));
            return this;
        }

        public final Builder addSolutionEntities(MessageEntity ... elements) {
            if (this.solutionEntities == null) {
                this.solutionEntities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.solutionEntities.add(Objects.requireNonNull(element, "solutionEntities element"));
            }
            return this;
        }

        public final Builder solutionEntities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.solutionEntities = null;
                return this;
            }
            this.solutionEntities = new ArrayList<MessageEntity>();
            return this.addAllSolutionEntities(elements);
        }

        public final Builder addAllSolutionEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "solutionEntities element");
            if (this.solutionEntities == null) {
                this.solutionEntities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.solutionEntities.add(Objects.requireNonNull(messageEntity, "solutionEntities element"));
            }
            return this;
        }

        public ImmutableInputMediaPoll build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaPoll(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("poll");
            }
            return "Cannot build InputMediaPoll, some of required attributes are not set " + attributes;
        }

        private List<ByteBuf> correctAnswers_build() {
            return this.correctAnswers_value.map(TlEncodingUtil::unmodifiableList).orElse(null);
        }

        private List<ByteBuf> correctAnswers_getOrCreate() {
            if (this.correctAnswers_value.isEmpty()) {
                this.correctAnswers_value = Optional.of(new ArrayList());
            }
            return this.correctAnswers_value.orElseThrow();
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMediaPoll.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMediaPoll.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputMediaPoll, attribute initializers form cycle " + attributes;
        }
    }
}

