/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputFile;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaUploadedDocument;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaUploadedDocument
implements InputMediaUploadedDocument {
    private final int identifier;
    private final int flags;
    private final boolean nosoundVideo;
    private final boolean forceFile;
    private final InputFile file;
    @Nullable
    private final InputFile thumb;
    private final String mimeType;
    private final List<DocumentAttribute> attributes;
    @Nullable
    private final List<InputDocument> stickers;
    @Nullable
    private final Integer ttlSeconds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputMediaUploadedDocument(InputFile file, String mimeType) {
        this.file = Objects.requireNonNull(file, "file");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.thumb = null;
        this.attributes = Collections.emptyList();
        this.stickers = null;
        this.ttlSeconds = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.nosoundVideo = this.initShim.nosoundVideo();
        this.forceFile = this.initShim.forceFile();
        this.initShim = null;
    }

    private ImmutableInputMediaUploadedDocument(Builder builder) {
        this.file = builder.file;
        this.thumb = builder.thumb;
        this.mimeType = builder.mimeType;
        this.attributes = ImmutableInputMediaUploadedDocument.createUnmodifiableList(true, builder.attributes);
        this.stickers = builder.stickers == null ? null : ImmutableInputMediaUploadedDocument.createUnmodifiableList(true, builder.stickers);
        this.ttlSeconds = builder.ttlSeconds;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.nosoundVideoIsSet()) {
            this.initShim.nosoundVideo(builder.nosoundVideo);
        }
        if (builder.forceFileIsSet()) {
            this.initShim.forceFile(builder.forceFile);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.nosoundVideo = this.initShim.nosoundVideo();
        this.forceFile = this.initShim.forceFile();
        this.initShim = null;
    }

    private ImmutableInputMediaUploadedDocument(int identifier, int flags, boolean nosoundVideo, boolean forceFile, InputFile file, @Nullable InputFile thumb, String mimeType, List<DocumentAttribute> attributes, @Nullable List<InputDocument> stickers, @Nullable Integer ttlSeconds) {
        this.identifier = identifier;
        this.flags = flags;
        this.nosoundVideo = nosoundVideo;
        this.forceFile = forceFile;
        this.file = file;
        this.thumb = thumb;
        this.mimeType = mimeType;
        this.attributes = attributes;
        this.stickers = stickers;
        this.ttlSeconds = ttlSeconds;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMediaUploadedDocument.super.identifier();
    }

    private int flagsInitialize() {
        return InputMediaUploadedDocument.super.flags();
    }

    private boolean nosoundVideoInitialize() {
        return InputMediaUploadedDocument.super.nosoundVideo();
    }

    private boolean forceFileInitialize() {
        return InputMediaUploadedDocument.super.forceFile();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean nosoundVideo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nosoundVideo() : this.nosoundVideo;
    }

    @Override
    public boolean forceFile() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forceFile() : this.forceFile;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    @Override
    @Nullable
    public InputFile thumb() {
        return this.thumb;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public List<DocumentAttribute> attributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public List<InputDocument> stickers() {
        return this.stickers;
    }

    @Override
    @Nullable
    public Integer ttlSeconds() {
        return this.ttlSeconds;
    }

    public final ImmutableInputMediaUploadedDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(value, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(this.identifier, value, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withNosoundVideo(boolean value) {
        if (this.nosoundVideo == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, value, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withForceFile(boolean value) {
        if (this.forceFile == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, value, this.file, this.thumb, this.mimeType, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, newValue, this.thumb, this.mimeType, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withThumb(@Nullable InputFile value) {
        if (this.thumb == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, value, this.mimeType, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, newValue, this.attributes, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withAttributes(DocumentAttribute ... elements) {
        List<DocumentAttribute> newValue = ImmutableInputMediaUploadedDocument.createUnmodifiableList(false, ImmutableInputMediaUploadedDocument.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, newValue, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withAttributes(Iterable<? extends DocumentAttribute> elements) {
        if (this.attributes == elements) {
            return this;
        }
        List<DocumentAttribute> newValue = ImmutableInputMediaUploadedDocument.createUnmodifiableList(false, ImmutableInputMediaUploadedDocument.createSafeList(elements, true, false));
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, newValue, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withStickers(InputDocument ... elements) {
        if (elements == null) {
            return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, null, this.ttlSeconds);
        }
        List<InputDocument> newValue = Arrays.asList(elements) == null ? null : ImmutableInputMediaUploadedDocument.createUnmodifiableList(false, ImmutableInputMediaUploadedDocument.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, newValue, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withStickers(@Nullable Iterable<? extends InputDocument> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<InputDocument> newValue = elements == null ? null : ImmutableInputMediaUploadedDocument.createUnmodifiableList(false, ImmutableInputMediaUploadedDocument.createSafeList(elements, true, false));
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, newValue, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedDocument withTtlSeconds(@Nullable Integer value) {
        if (Objects.equals(this.ttlSeconds, value)) {
            return this;
        }
        return new ImmutableInputMediaUploadedDocument(this.identifier, this.flags, this.nosoundVideo, this.forceFile, this.file, this.thumb, this.mimeType, this.attributes, this.stickers, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaUploadedDocument && this.equalTo(0, (ImmutableInputMediaUploadedDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaUploadedDocument another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.nosoundVideo == another.nosoundVideo && this.forceFile == another.forceFile && this.file.equals(another.file) && Objects.equals(this.thumb, another.thumb) && this.mimeType.equals(another.mimeType) && this.attributes.equals(another.attributes) && Objects.equals(this.stickers, another.stickers) && Objects.equals(this.ttlSeconds, another.ttlSeconds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.nosoundVideo);
        h += (h << 5) + Boolean.hashCode(this.forceFile);
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + Objects.hashCode(this.thumb);
        h += (h << 5) + this.mimeType.hashCode();
        h += (h << 5) + this.attributes.hashCode();
        h += (h << 5) + Objects.hashCode(this.stickers);
        h += (h << 5) + Objects.hashCode(this.ttlSeconds);
        return h;
    }

    public String toString() {
        return "InputMediaUploadedDocument{identifier=" + this.identifier + ", flags=" + this.flags + ", nosoundVideo=" + this.nosoundVideo + ", forceFile=" + this.forceFile + ", file=" + this.file + ", thumb=" + this.thumb + ", mimeType=" + this.mimeType + ", attributes=" + this.attributes + ", stickers=" + this.stickers + ", ttlSeconds=" + this.ttlSeconds + "}";
    }

    public static ImmutableInputMediaUploadedDocument of(InputFile file, String mimeType) {
        return new ImmutableInputMediaUploadedDocument(file, mimeType);
    }

    public static ImmutableInputMediaUploadedDocument copyOf(InputMediaUploadedDocument instance) {
        if (instance instanceof ImmutableInputMediaUploadedDocument) {
            return (ImmutableInputMediaUploadedDocument)instance;
        }
        return ImmutableInputMediaUploadedDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_MIME_TYPE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NOSOUND_VIDEO = 4L;
        private static final long OPT_BIT_FORCE_FILE = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean nosoundVideo;
        private boolean forceFile;
        private InputFile file;
        private InputFile thumb;
        private String mimeType;
        private List<DocumentAttribute> attributes = new ArrayList<DocumentAttribute>();
        private List<InputDocument> stickers = null;
        private Integer ttlSeconds;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMediaUploadedDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMediaUploadedDocument) {
                instance = (InputMediaUploadedDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.file(instance.file());
                InputFile thumbValue = instance.thumb();
                if (thumbValue != null) {
                    this.thumb(thumbValue);
                }
                this.flags(instance.flags());
                this.forceFile(instance.forceFile());
                this.addAllAttributes(instance.attributes());
                List<InputDocument> stickersValue = instance.stickers();
                if (stickersValue != null) {
                    this.addAllStickers(stickersValue);
                }
                this.mimeType(instance.mimeType());
                this.nosoundVideo(instance.nosoundVideo());
                Integer ttlSecondsValue = instance.ttlSeconds();
                if (ttlSecondsValue != null) {
                    this.ttlSeconds(ttlSecondsValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder nosoundVideo(boolean nosoundVideo) {
            this.nosoundVideo = nosoundVideo;
            this.optBits |= 4L;
            return this;
        }

        public final Builder forceFile(boolean forceFile) {
            this.forceFile = forceFile;
            this.optBits |= 8L;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder thumb(@Nullable InputFile thumb) {
            this.thumb = thumb;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addAttribute(DocumentAttribute element) {
            this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            return this;
        }

        public final Builder addAttributes(DocumentAttribute ... elements) {
            for (DocumentAttribute element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder attributes(Iterable<? extends DocumentAttribute> elements) {
            this.attributes.clear();
            return this.addAllAttributes(elements);
        }

        public final Builder addAllAttributes(Iterable<? extends DocumentAttribute> elements) {
            for (DocumentAttribute documentAttribute : elements) {
                this.attributes.add(Objects.requireNonNull(documentAttribute, "attributes element"));
            }
            return this;
        }

        public final Builder addSticker(InputDocument element) {
            if (this.stickers == null) {
                this.stickers = new ArrayList<InputDocument>();
            }
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(InputDocument ... elements) {
            if (this.stickers == null) {
                this.stickers = new ArrayList<InputDocument>();
            }
            for (InputDocument element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        public final Builder stickers(@Nullable Iterable<? extends InputDocument> elements) {
            if (elements == null) {
                this.stickers = null;
                return this;
            }
            this.stickers = new ArrayList<InputDocument>();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends InputDocument> elements) {
            Objects.requireNonNull(elements, "stickers element");
            if (this.stickers == null) {
                this.stickers = new ArrayList<InputDocument>();
            }
            for (InputDocument inputDocument : elements) {
                this.stickers.add(Objects.requireNonNull(inputDocument, "stickers element"));
            }
            return this;
        }

        public final Builder ttlSeconds(@Nullable Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public ImmutableInputMediaUploadedDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaUploadedDocument(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nosoundVideoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean forceFileIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mimeType");
            }
            return "Cannot build InputMediaUploadedDocument, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte nosoundVideoBuildStage = 0;
        private boolean nosoundVideo;
        private byte forceFileBuildStage = 0;
        private boolean forceFile;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMediaUploadedDocument.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMediaUploadedDocument.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean nosoundVideo() {
            if (this.nosoundVideoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nosoundVideoBuildStage == 0) {
                this.nosoundVideoBuildStage = (byte)-1;
                this.nosoundVideo = ImmutableInputMediaUploadedDocument.this.nosoundVideoInitialize();
                this.nosoundVideoBuildStage = 1;
            }
            return this.nosoundVideo;
        }

        void nosoundVideo(boolean nosoundVideo) {
            this.nosoundVideo = nosoundVideo;
            this.nosoundVideoBuildStage = 1;
        }

        boolean forceFile() {
            if (this.forceFileBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceFileBuildStage == 0) {
                this.forceFileBuildStage = (byte)-1;
                this.forceFile = ImmutableInputMediaUploadedDocument.this.forceFileInitialize();
                this.forceFileBuildStage = 1;
            }
            return this.forceFile;
        }

        void forceFile(boolean forceFile) {
            this.forceFile = forceFile;
            this.forceFileBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.nosoundVideoBuildStage == -1) {
                attributes.add("nosoundVideo");
            }
            if (this.forceFileBuildStage == -1) {
                attributes.add("forceFile");
            }
            return "Cannot build InputMediaUploadedDocument, attribute initializers form cycle " + attributes;
        }
    }
}

