/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputFile;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaUploadedPhoto;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaUploadedPhoto
implements InputMediaUploadedPhoto {
    private final int identifier;
    private final int flags;
    private final InputFile file;
    @Nullable
    private final List<InputDocument> stickers;
    @Nullable
    private final Integer ttlSeconds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputMediaUploadedPhoto(InputFile file) {
        this.file = Objects.requireNonNull(file, "file");
        this.stickers = null;
        this.ttlSeconds = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaUploadedPhoto(Builder builder) {
        this.file = builder.file;
        this.stickers = builder.stickers == null ? null : ImmutableInputMediaUploadedPhoto.createUnmodifiableList(true, builder.stickers);
        this.ttlSeconds = builder.ttlSeconds;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputMediaUploadedPhoto(int identifier, int flags, InputFile file, @Nullable List<InputDocument> stickers, @Nullable Integer ttlSeconds) {
        this.identifier = identifier;
        this.flags = flags;
        this.file = file;
        this.stickers = stickers;
        this.ttlSeconds = ttlSeconds;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMediaUploadedPhoto.super.identifier();
    }

    private int flagsInitialize() {
        return InputMediaUploadedPhoto.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    @Override
    @Nullable
    public List<InputDocument> stickers() {
        return this.stickers;
    }

    @Override
    @Nullable
    public Integer ttlSeconds() {
        return this.ttlSeconds;
    }

    public final ImmutableInputMediaUploadedPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedPhoto(value, this.flags, this.file, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedPhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputMediaUploadedPhoto(this.identifier, value, this.file, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedPhoto withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableInputMediaUploadedPhoto(this.identifier, this.flags, newValue, this.stickers, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedPhoto withStickers(InputDocument ... elements) {
        if (elements == null) {
            return new ImmutableInputMediaUploadedPhoto(this.identifier, this.flags, this.file, null, this.ttlSeconds);
        }
        List<InputDocument> newValue = Arrays.asList(elements) == null ? null : ImmutableInputMediaUploadedPhoto.createUnmodifiableList(false, ImmutableInputMediaUploadedPhoto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputMediaUploadedPhoto(this.identifier, this.flags, this.file, newValue, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedPhoto withStickers(@Nullable Iterable<? extends InputDocument> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<InputDocument> newValue = elements == null ? null : ImmutableInputMediaUploadedPhoto.createUnmodifiableList(false, ImmutableInputMediaUploadedPhoto.createSafeList(elements, true, false));
        return new ImmutableInputMediaUploadedPhoto(this.identifier, this.flags, this.file, newValue, this.ttlSeconds);
    }

    public final ImmutableInputMediaUploadedPhoto withTtlSeconds(@Nullable Integer value) {
        if (Objects.equals(this.ttlSeconds, value)) {
            return this;
        }
        return new ImmutableInputMediaUploadedPhoto(this.identifier, this.flags, this.file, this.stickers, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaUploadedPhoto && this.equalTo(0, (ImmutableInputMediaUploadedPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaUploadedPhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.file.equals(another.file) && Objects.equals(this.stickers, another.stickers) && Objects.equals(this.ttlSeconds, another.ttlSeconds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + Objects.hashCode(this.stickers);
        h += (h << 5) + Objects.hashCode(this.ttlSeconds);
        return h;
    }

    public String toString() {
        return "InputMediaUploadedPhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", file=" + this.file + ", stickers=" + this.stickers + ", ttlSeconds=" + this.ttlSeconds + "}";
    }

    public static ImmutableInputMediaUploadedPhoto of(InputFile file) {
        return new ImmutableInputMediaUploadedPhoto(file);
    }

    public static ImmutableInputMediaUploadedPhoto copyOf(InputMediaUploadedPhoto instance) {
        if (instance instanceof ImmutableInputMediaUploadedPhoto) {
            return (ImmutableInputMediaUploadedPhoto)instance;
        }
        return ImmutableInputMediaUploadedPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputFile file;
        private List<InputDocument> stickers = null;
        private Integer ttlSeconds;

        private Builder() {
        }

        public final Builder from(InputMediaUploadedPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaUploadedPhoto) {
                List<InputDocument> stickersValue;
                instance = (InputMediaUploadedPhoto)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((stickersValue = instance.stickers()) != null) {
                    this.addAllStickers(stickersValue);
                }
                this.file(instance.file());
                Integer ttlSecondsValue = instance.ttlSeconds();
                if (ttlSecondsValue != null) {
                    this.ttlSeconds(ttlSecondsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSticker(InputDocument element) {
            if (this.stickers == null) {
                this.stickers = new ArrayList<InputDocument>();
            }
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(InputDocument ... elements) {
            if (this.stickers == null) {
                this.stickers = new ArrayList<InputDocument>();
            }
            for (InputDocument element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        public final Builder stickers(@Nullable Iterable<? extends InputDocument> elements) {
            if (elements == null) {
                this.stickers = null;
                return this;
            }
            this.stickers = new ArrayList<InputDocument>();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends InputDocument> elements) {
            Objects.requireNonNull(elements, "stickers element");
            if (this.stickers == null) {
                this.stickers = new ArrayList<InputDocument>();
            }
            for (InputDocument inputDocument : elements) {
                this.stickers.add(Objects.requireNonNull(inputDocument, "stickers element"));
            }
            return this;
        }

        public final Builder ttlSeconds(@Nullable Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public ImmutableInputMediaUploadedPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaUploadedPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build InputMediaUploadedPhoto, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMediaUploadedPhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMediaUploadedPhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputMediaUploadedPhoto, attribute initializers form cycle " + attributes;
        }
    }
}

