/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputMediaVenue;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMediaVenue
implements InputMediaVenue {
    private final int identifier;
    private final InputGeoPoint geoPoint;
    private final String title;
    private final String address;
    private final String provider;
    private final String venueId;
    private final String venueType;

    private ImmutableInputMediaVenue(InputGeoPoint geoPoint, String title, String address, String provider, String venueId, String venueType) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.title = Objects.requireNonNull(title, "title");
        this.address = Objects.requireNonNull(address, "address");
        this.provider = Objects.requireNonNull(provider, "provider");
        this.venueId = Objects.requireNonNull(venueId, "venueId");
        this.venueType = Objects.requireNonNull(venueType, "venueType");
        this.identifier = InputMediaVenue.super.identifier();
    }

    private ImmutableInputMediaVenue(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.title = builder.title;
        this.address = builder.address;
        this.provider = builder.provider;
        this.venueId = builder.venueId;
        this.venueType = builder.venueType;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMediaVenue.super.identifier();
    }

    private ImmutableInputMediaVenue(int identifier, InputGeoPoint geoPoint, String title, String address, String provider, String venueId, String venueType) {
        this.identifier = identifier;
        this.geoPoint = geoPoint;
        this.title = title;
        this.address = address;
        this.provider = provider;
        this.venueId = venueId;
        this.venueType = venueType;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String venueId() {
        return this.venueId;
    }

    @Override
    public String venueType() {
        return this.venueType;
    }

    public final ImmutableInputMediaVenue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMediaVenue(value, this.geoPoint, this.title, this.address, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableInputMediaVenue withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableInputMediaVenue(this.identifier, newValue, this.title, this.address, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableInputMediaVenue withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaVenue(this.identifier, this.geoPoint, newValue, this.address, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableInputMediaVenue withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaVenue(this.identifier, this.geoPoint, this.title, newValue, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableInputMediaVenue withProvider(String value) {
        String newValue = Objects.requireNonNull(value, "provider");
        if (this.provider.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaVenue(this.identifier, this.geoPoint, this.title, this.address, newValue, this.venueId, this.venueType);
    }

    public final ImmutableInputMediaVenue withVenueId(String value) {
        String newValue = Objects.requireNonNull(value, "venueId");
        if (this.venueId.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaVenue(this.identifier, this.geoPoint, this.title, this.address, this.provider, newValue, this.venueType);
    }

    public final ImmutableInputMediaVenue withVenueType(String value) {
        String newValue = Objects.requireNonNull(value, "venueType");
        if (this.venueType.equals(newValue)) {
            return this;
        }
        return new ImmutableInputMediaVenue(this.identifier, this.geoPoint, this.title, this.address, this.provider, this.venueId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMediaVenue && this.equalTo(0, (ImmutableInputMediaVenue)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMediaVenue another) {
        return this.identifier == another.identifier && this.geoPoint.equals(another.geoPoint) && this.title.equals(another.title) && this.address.equals(another.address) && this.provider.equals(another.provider) && this.venueId.equals(another.venueId) && this.venueType.equals(another.venueType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.venueId.hashCode();
        h += (h << 5) + this.venueType.hashCode();
        return h;
    }

    public String toString() {
        return "InputMediaVenue{identifier=" + this.identifier + ", geoPoint=" + this.geoPoint + ", title=" + this.title + ", address=" + this.address + ", provider=" + this.provider + ", venueId=" + this.venueId + ", venueType=" + this.venueType + "}";
    }

    public static ImmutableInputMediaVenue of(InputGeoPoint geoPoint, String title, String address, String provider, String venueId, String venueType) {
        return new ImmutableInputMediaVenue(geoPoint, title, address, provider, venueId, venueType);
    }

    public static ImmutableInputMediaVenue copyOf(InputMediaVenue instance) {
        if (instance instanceof ImmutableInputMediaVenue) {
            return (ImmutableInputMediaVenue)instance;
        }
        return ImmutableInputMediaVenue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_PROVIDER = 8L;
        private static final long INIT_BIT_VENUE_ID = 16L;
        private static final long INIT_BIT_VENUE_TYPE = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private InputGeoPoint geoPoint;
        private String title;
        private String address;
        private String provider;
        private String venueId;
        private String venueType;

        private Builder() {
        }

        public final Builder from(InputMediaVenue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMedia instance;
            long bits = 0L;
            if (object instanceof InputMediaVenue) {
                instance = (InputMediaVenue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.address(instance.address());
                this.venueType(instance.venueType());
                this.provider(instance.provider());
                this.venueId(instance.venueId());
                this.geoPoint(instance.geoPoint());
                this.title(instance.title());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMedia) {
                instance = (InputMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder venueId(String venueId) {
            this.venueId = Objects.requireNonNull(venueId, "venueId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder venueType(String venueType) {
            this.venueType = Objects.requireNonNull(venueType, "venueType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableInputMediaVenue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMediaVenue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("venueId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("venueType");
            }
            return "Cannot build InputMediaVenue, some of required attributes are not set " + attributes;
        }
    }
}

