/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMessageEntityMentionName;
import telegram4j.tl.InputUser;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessageEntityMentionName
implements InputMessageEntityMentionName {
    private final int identifier;
    private final int offset;
    private final int length;
    private final InputUser userId;

    private ImmutableInputMessageEntityMentionName(int offset, int length, InputUser userId) {
        this.offset = offset;
        this.length = length;
        this.userId = Objects.requireNonNull(userId, "userId");
        this.identifier = InputMessageEntityMentionName.super.identifier();
    }

    private ImmutableInputMessageEntityMentionName(Builder builder) {
        this.offset = builder.offset;
        this.length = builder.length;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessageEntityMentionName.super.identifier();
    }

    private ImmutableInputMessageEntityMentionName(int identifier, int offset, int length, InputUser userId) {
        this.identifier = identifier;
        this.offset = offset;
        this.length = length;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    public final ImmutableInputMessageEntityMentionName withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMessageEntityMentionName(value, this.offset, this.length, this.userId);
    }

    public final ImmutableInputMessageEntityMentionName withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableInputMessageEntityMentionName(this.identifier, value, this.length, this.userId);
    }

    public final ImmutableInputMessageEntityMentionName withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableInputMessageEntityMentionName(this.identifier, this.offset, value, this.userId);
    }

    public final ImmutableInputMessageEntityMentionName withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableInputMessageEntityMentionName(this.identifier, this.offset, this.length, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessageEntityMentionName && this.equalTo(0, (ImmutableInputMessageEntityMentionName)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessageEntityMentionName another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.length == another.length && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.length;
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "InputMessageEntityMentionName{identifier=" + this.identifier + ", offset=" + this.offset + ", length=" + this.length + ", userId=" + this.userId + "}";
    }

    public static ImmutableInputMessageEntityMentionName of(int offset, int length, InputUser userId) {
        return new ImmutableInputMessageEntityMentionName(offset, length, userId);
    }

    public static ImmutableInputMessageEntityMentionName copyOf(InputMessageEntityMentionName instance) {
        if (instance instanceof ImmutableInputMessageEntityMentionName) {
            return (ImmutableInputMessageEntityMentionName)instance;
        }
        return ImmutableInputMessageEntityMentionName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int offset;
        private int length;
        private InputUser userId;

        private Builder() {
        }

        public final Builder from(MessageEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessageEntityMentionName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageEntity instance;
            long bits = 0L;
            if (object instanceof MessageEntity) {
                instance = (MessageEntity)object;
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessageEntityMentionName) {
                instance = (InputMessageEntityMentionName)object;
                if ((bits & 4L) == 0L) {
                    this.length(instance.length());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.offset(instance.offset());
                    bits |= 2L;
                }
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputMessageEntityMentionName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMessageEntityMentionName(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build InputMessageEntityMentionName, some of required attributes are not set " + attributes;
        }
    }
}

