/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessage;
import telegram4j.tl.InputMessagePinned;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagePinned
implements InputMessagePinned {
    private final int identifier;
    private static final ImmutableInputMessagePinned INSTANCE = ImmutableInputMessagePinned.validate(new ImmutableInputMessagePinned());

    private ImmutableInputMessagePinned() {
        this.identifier = InputMessagePinned.super.identifier();
    }

    private ImmutableInputMessagePinned(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagePinned.super.identifier();
    }

    private ImmutableInputMessagePinned(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagePinned withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagePinned.validate(new ImmutableInputMessagePinned(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagePinned && this.equalTo(0, (ImmutableInputMessagePinned)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagePinned another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagePinned{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagePinned of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagePinned validate(ImmutableInputMessagePinned instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagePinned copyOf(InputMessagePinned instance) {
        if (instance instanceof ImmutableInputMessagePinned) {
            return (ImmutableInputMessagePinned)instance;
        }
        return ImmutableInputMessagePinned.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputMessagePinned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMessage instance;
            long bits = 0L;
            if (object instanceof InputMessagePinned) {
                instance = (InputMessagePinned)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessage) {
                instance = (InputMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagePinned build() {
            return ImmutableInputMessagePinned.validate(new ImmutableInputMessagePinned(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

