/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMessage;
import telegram4j.tl.InputMessageReplyTo;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessageReplyTo
implements InputMessageReplyTo {
    private final int identifier;
    private final int id;

    private ImmutableInputMessageReplyTo(int id) {
        this.id = id;
        this.identifier = InputMessageReplyTo.super.identifier();
    }

    private ImmutableInputMessageReplyTo(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessageReplyTo.super.identifier();
    }

    private ImmutableInputMessageReplyTo(int identifier, int id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int id() {
        return this.id;
    }

    public final ImmutableInputMessageReplyTo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputMessageReplyTo(value, this.id);
    }

    public final ImmutableInputMessageReplyTo withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputMessageReplyTo(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessageReplyTo && this.equalTo(0, (ImmutableInputMessageReplyTo)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessageReplyTo another) {
        return this.identifier == another.identifier && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id;
        return h;
    }

    public String toString() {
        return "InputMessageReplyTo{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableInputMessageReplyTo of(int id) {
        return new ImmutableInputMessageReplyTo(id);
    }

    public static ImmutableInputMessageReplyTo copyOf(InputMessageReplyTo instance) {
        if (instance instanceof ImmutableInputMessageReplyTo) {
            return (ImmutableInputMessageReplyTo)instance;
        }
        return ImmutableInputMessageReplyTo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int id;

        private Builder() {
        }

        public final Builder from(InputMessageReplyTo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputMessage instance;
            long bits = 0L;
            if (object instanceof InputMessageReplyTo) {
                instance = (InputMessageReplyTo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessage) {
                instance = (InputMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputMessageReplyTo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputMessageReplyTo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build InputMessageReplyTo, some of required attributes are not set " + attributes;
        }
    }
}

